/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import com.example.playerdatasync.MessageManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final int resourceId;
    private final MessageManager messageManager;

    public UpdateChecker(JavaPlugin plugin, int resourceId, MessageManager messageManager) {
        this.plugin = plugin;
        this.resourceId = resourceId;
        this.messageManager = messageManager;
    }

    public void check() {
        if (!this.plugin.getConfig().getBoolean("update_checker.enabled", true)) {
            this.plugin.getLogger().info(this.messageManager.get("update_check_disabled"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openConnection();
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setRequestProperty("User-Agent", "PlayerDataSync/" + this.plugin.getDescription().getVersion());
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", "HTTP " + responseCode));
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String latestVersion = reader.readLine();
                    if (latestVersion == null || latestVersion.isEmpty()) {
                        this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", "Empty response"));
                        return;
                    }
                    String currentVersion = this.plugin.getDescription().getVersion();
                    if (currentVersion.equalsIgnoreCase(latestVersion)) {
                        if (this.plugin.getConfig().getBoolean("update_checker.notify_ops", true)) {
                            this.plugin.getLogger().info(this.messageManager.get("update_current"));
                        }
                    } else {
                        this.plugin.getLogger().info(this.messageManager.get("update_available", latestVersion));
                        this.plugin.getLogger().info(this.messageManager.get("update_download_url", "https://www.spigotmc.org/resources/" + this.resourceId));
                    }
                }
            }
            catch (UnknownHostException e) {
                this.plugin.getLogger().fine(this.messageManager.get("update_check_no_internet"));
            }
            catch (SocketTimeoutException e) {
                this.plugin.getLogger().warning(this.messageManager.get("update_check_timeout"));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", e.getMessage()));
            }
        });
    }
}

