/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import com.example.playerdatasync.AdvancementSyncManager;
import com.example.playerdatasync.DatabaseManager;
import com.example.playerdatasync.MessageManager;
import com.example.playerdatasync.PlayerDataSync;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDataListener
implements Listener {
    private final PlayerDataSync plugin;
    private final DatabaseManager dbManager;
    private final MessageManager messageManager;

    public PlayerDataListener(PlayerDataSync plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.messageManager = plugin.getMessageManager();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("playerdatasync.message.show.loading")) {
            player.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("loading"));
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
            block3: {
                try {
                    this.dbManager.loadPlayer(player);
                    if (player.isOnline() && player.hasPermission("playerdatasync.message.show.loaded")) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("loaded")));
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Error loading data for " + player.getName() + ": " + e.getMessage());
                    if (!player.isOnline()) break block3;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("load_failed")));
                }
            }
        }, 1L);
        AdvancementSyncManager advancementSyncManager = this.plugin.getAdvancementSyncManager();
        if (advancementSyncManager != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> advancementSyncManager.handlePlayerJoin(player), 2L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        try {
            long startTime = System.currentTimeMillis();
            boolean saved = this.dbManager.savePlayer(player);
            long endTime = System.currentTimeMillis();
            if (saved && endTime - startTime > 1000L) {
                this.plugin.getLogger().warning("Slow save detected for " + player.getName() + ": " + (endTime - startTime) + "ms");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to save data for " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        AdvancementSyncManager advancementSyncManager = this.plugin.getAdvancementSyncManager();
        if (advancementSyncManager != null) {
            advancementSyncManager.handlePlayerQuit(player);
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        if (!this.plugin.getConfig().getBoolean("autosave.on_world_change", true)) {
            return;
        }
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.dbManager.savePlayer(player);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to save data for " + player.getName() + " on world change: " + e.getMessage());
            }
        });
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.plugin.getConfig().getBoolean("autosave.on_death", true)) {
            return;
        }
        Player player = event.getEntity();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.dbManager.savePlayer(player);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to save data for " + player.getName() + " on death: " + e.getMessage());
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerKick(PlayerKickEvent event) {
        if (!this.plugin.getConfig().getBoolean("autosave.on_kick", true)) {
            return;
        }
        Player player = event.getPlayer();
        this.plugin.logDebug("Player " + player.getName() + " was kicked, saving data");
        try {
            long startTime = System.currentTimeMillis();
            this.dbManager.savePlayer(player);
            long endTime = System.currentTimeMillis();
            this.plugin.logDebug("Saved data for kicked player " + player.getName() + " in " + (endTime - startTime) + "ms");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to save data for kicked player " + player.getName() + ": " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (!this.plugin.getConfig().getBoolean("autosave.on_server_switch", true)) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            Player player = event.getPlayer();
            if (event.getTo() != null && event.getTo().getWorld() != null) {
                String currentServer = this.plugin.getConfig().getString("server.id", "default");
                this.plugin.logDebug("Player " + player.getName() + " teleported via plugin, saving data");
                try {
                    long startTime = System.currentTimeMillis();
                    this.dbManager.savePlayer(player);
                    long endTime = System.currentTimeMillis();
                    this.plugin.logDebug("Saved data for teleporting player " + player.getName() + " in " + (endTime - startTime) + "ms");
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to save data for teleporting player " + player.getName() + ": " + e.getMessage());
                }
            }
        }
    }
}

