/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import com.example.playerdatasync.PlayerDataSync;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.entity.Player;

public class PlayerDataCache {
    private final PlayerDataSync plugin;
    private final ConcurrentHashMap<UUID, CachedPlayerData> cache;
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong misses = new AtomicLong(0L);
    private final AtomicLong evictions = new AtomicLong(0L);
    private final int maxCacheSize;
    private final long defaultTTL;
    private final boolean enableCompression;

    public PlayerDataCache(PlayerDataSync plugin) {
        this.plugin = plugin;
        this.cache = new ConcurrentHashMap();
        this.maxCacheSize = plugin.getConfig().getInt("performance.cache_size", 100);
        this.defaultTTL = plugin.getConfig().getLong("performance.cache_ttl", 300000L);
        this.enableCompression = plugin.getConfig().getBoolean("performance.cache_compression", true);
    }

    public void cachePlayerData(Player player, CachedPlayerData data) {
        if (this.cache.size() >= this.maxCacheSize) {
            this.evictLeastRecentlyUsed();
        }
        data.setLastAccessed(System.currentTimeMillis());
        data.setTtl(this.defaultTTL);
        if (this.enableCompression) {
            data.compress();
        }
        this.cache.put(player.getUniqueId(), data);
    }

    public CachedPlayerData getCachedPlayerData(Player player) {
        CachedPlayerData data = this.cache.get(player.getUniqueId());
        if (data == null) {
            this.misses.incrementAndGet();
            return null;
        }
        if (data.isExpired()) {
            this.cache.remove(player.getUniqueId());
            this.misses.incrementAndGet();
            return null;
        }
        data.setLastAccessed(System.currentTimeMillis());
        this.hits.incrementAndGet();
        if (this.enableCompression && data.isCompressed()) {
            data.decompress();
        }
        return data;
    }

    public void removePlayerData(Player player) {
        this.cache.remove(player.getUniqueId());
    }

    public void clearCache() {
        this.cache.clear();
        this.hits.set(0L);
        this.misses.set(0L);
        this.evictions.set(0L);
    }

    private void evictLeastRecentlyUsed() {
        if (this.cache.isEmpty()) {
            return;
        }
        UUID oldestKey = null;
        long oldestTime = Long.MAX_VALUE;
        for (Map.Entry<UUID, CachedPlayerData> entry : this.cache.entrySet()) {
            if (entry.getValue().getLastAccessed() >= oldestTime) continue;
            oldestTime = entry.getValue().getLastAccessed();
            oldestKey = entry.getKey();
        }
        if (oldestKey != null) {
            this.cache.remove(oldestKey);
            this.evictions.incrementAndGet();
        }
    }

    public void cleanExpiredEntries() {
        this.cache.entrySet().removeIf(entry -> ((CachedPlayerData)entry.getValue()).isExpired());
    }

    public CacheStats getStats() {
        long totalRequests = this.hits.get() + this.misses.get();
        double hitRate = totalRequests > 0L ? (double)this.hits.get() / (double)totalRequests * 100.0 : 0.0;
        return new CacheStats(this.cache.size(), this.maxCacheSize, this.hits.get(), this.misses.get(), this.evictions.get(), hitRate);
    }

    public static class CachedPlayerData {
        private String inventoryData;
        private String enderChestData;
        private String armorData;
        private String offhandData;
        private String effectsData;
        private String statisticsData;
        private String attributesData;
        private String advancementsData;
        private long lastAccessed = System.currentTimeMillis();
        private long ttl;
        private boolean compressed = false;

        public String getInventoryData() {
            return this.inventoryData;
        }

        public void setInventoryData(String inventoryData) {
            this.inventoryData = inventoryData;
        }

        public String getEnderChestData() {
            return this.enderChestData;
        }

        public void setEnderChestData(String enderChestData) {
            this.enderChestData = enderChestData;
        }

        public String getArmorData() {
            return this.armorData;
        }

        public void setArmorData(String armorData) {
            this.armorData = armorData;
        }

        public String getOffhandData() {
            return this.offhandData;
        }

        public void setOffhandData(String offhandData) {
            this.offhandData = offhandData;
        }

        public String getEffectsData() {
            return this.effectsData;
        }

        public void setEffectsData(String effectsData) {
            this.effectsData = effectsData;
        }

        public String getStatisticsData() {
            return this.statisticsData;
        }

        public void setStatisticsData(String statisticsData) {
            this.statisticsData = statisticsData;
        }

        public String getAttributesData() {
            return this.attributesData;
        }

        public void setAttributesData(String attributesData) {
            this.attributesData = attributesData;
        }

        public String getAdvancementsData() {
            return this.advancementsData;
        }

        public void setAdvancementsData(String advancementsData) {
            this.advancementsData = advancementsData;
        }

        public long getLastAccessed() {
            return this.lastAccessed;
        }

        public void setLastAccessed(long lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        public long getTtl() {
            return this.ttl;
        }

        public void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.lastAccessed > this.ttl;
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }

        public void compress() {
            this.compressed = true;
        }

        public void decompress() {
            this.compressed = false;
        }
    }

    public static class CacheStats {
        private final int currentSize;
        private final int maxSize;
        private final long hits;
        private final long misses;
        private final long evictions;
        private final double hitRate;

        public CacheStats(int currentSize, int maxSize, long hits, long misses, long evictions, double hitRate) {
            this.currentSize = currentSize;
            this.maxSize = maxSize;
            this.hits = hits;
            this.misses = misses;
            this.evictions = evictions;
            this.hitRate = hitRate;
        }

        public String toString() {
            return String.format("Cache: %d/%d entries, Hit Rate: %.1f%%, Hits: %d, Misses: %d, Evictions: %d", this.currentSize, this.maxSize, this.hitRate, this.hits, this.misses, this.evictions);
        }

        public int getCurrentSize() {
            return this.currentSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public long getHits() {
            return this.hits;
        }

        public long getMisses() {
            return this.misses;
        }

        public long getEvictions() {
            return this.evictions;
        }

        public double getHitRate() {
            return this.hitRate;
        }
    }
}

