/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import com.example.playerdatasync.PlayerDataSync;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final PlayerDataSync plugin;
    private FileConfiguration messages;

    public MessageManager(PlayerDataSync plugin) {
        this.plugin = plugin;
    }

    public void load(String language) {
        String normalized = this.normalizeLanguage(language);
        YamlConfiguration baseEn = new YamlConfiguration();
        InputStream enStream = this.plugin.getResource("messages_en.yml");
        if (enStream != null) {
            baseEn = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(enStream, StandardCharsets.UTF_8));
        } else {
            File enFile = new File(this.plugin.getDataFolder(), "messages_en.yml");
            if (enFile.exists()) {
                baseEn = YamlConfiguration.loadConfiguration((File)enFile);
            }
        }
        YamlConfiguration selected = null;
        File file = new File(this.plugin.getDataFolder(), "messages_" + normalized + ".yml");
        try {
            if (!file.exists()) {
                this.plugin.saveResource("messages_" + normalized + ".yml", false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (file.exists()) {
            selected = YamlConfiguration.loadConfiguration((File)file);
        } else {
            InputStream jarStream = this.plugin.getResource("messages_" + normalized + ".yml");
            if (jarStream != null) {
                selected = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(jarStream, StandardCharsets.UTF_8));
            }
        }
        if (selected == null) {
            this.messages = baseEn;
            return;
        }
        selected.setDefaults((Configuration)baseEn);
        selected.options().copyDefaults(true);
        this.messages = selected;
    }

    public void loadFromConfig() {
        String lang = this.plugin.getConfig().getString("messages.language", "en");
        this.load(lang);
    }

    private String normalizeLanguage(String language) {
        if (language == null || language.trim().isEmpty()) {
            return "en";
        }
        String lang = language.trim().toLowerCase().replace('-', '_');
        if (lang.startsWith("de")) {
            return "de";
        }
        if (lang.startsWith("en")) {
            return "en";
        }
        return lang;
    }

    public String get(String key) {
        if (this.messages == null) {
            return key;
        }
        String raw = this.messages.getString(key, key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
    }

    public String get(String key, String ... params) {
        if (this.messages == null) {
            return key;
        }
        String raw = this.messages.getString(key, key);
        for (int i = 0; i < params.length; ++i) {
            String placeholder = "{" + i + "}";
            if (!raw.contains(placeholder)) continue;
            raw = raw.replace(placeholder, params[i] != null ? params[i] : "");
        }
        if (params.length > 0) {
            raw = raw.replace("{version}", params[0] != null ? params[0] : "");
            raw = raw.replace("{error}", params[0] != null ? params[0] : "");
            raw = raw.replace("{url}", params[0] != null ? params[0] : "");
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
    }
}

