/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class InventoryUtils {
    private static final String DOWNGRADE_ERROR_FRAGMENT = "Server downgrades are not supported";
    private static final String NEWER_VERSION_FRAGMENT = "Newer version";

    public static String itemStackArrayToBase64(ItemStack[] items) throws IOException {
        if (items == null) {
            return "";
        }
        ItemStack[] sanitizedItems = InventoryUtils.sanitizeItemStackArray(items);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
            dataOutput.writeInt(sanitizedItems.length);
            for (ItemStack item : sanitizedItems) {
                dataOutput.writeObject((Object)item);
            }
        }
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static ItemStack[] itemStackArrayFromBase64(String data) throws IOException, ClassNotFoundException {
        ItemStack[] items;
        if (data == null || data.isEmpty()) {
            return new ItemStack[0];
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
        try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
            int length = dataInput.readInt();
            items = new ItemStack[length];
            for (int i = 0; i < length; ++i) {
                try {
                    items[i] = (ItemStack)dataInput.readObject();
                    continue;
                }
                catch (Exception e) {
                    if (InventoryUtils.isVersionDowngradeIssue(e)) {
                        System.err.println("[PlayerDataSync] Version compatibility issue detected for item " + i + ": " + InventoryUtils.collectCompatibilityMessage(e) + ". Skipping unsupported item.");
                        items[i] = null;
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (!InventoryUtils.validateItemStackArray(items)) {
            return InventoryUtils.sanitizeItemStackArray(items);
        }
        return items;
    }

    public static String itemStackToBase64(ItemStack item) throws IOException {
        if (item == null) {
            return "";
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
            dataOutput.writeObject((Object)item);
        }
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static ItemStack itemStackFromBase64(String data) throws IOException, ClassNotFoundException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
        try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
            ItemStack itemStack = (ItemStack)dataInput.readObject();
            return itemStack;
        }
    }

    public static boolean validateItemStackArray(ItemStack[] items) {
        if (items == null) {
            return true;
        }
        try {
            for (ItemStack item : items) {
                if (item == null) continue;
                item.getType();
                item.getAmount();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ItemStack[] sanitizeItemStackArray(ItemStack[] items) {
        if (items == null) {
            return null;
        }
        ItemStack[] sanitized = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            try {
                ItemStack item = items[i];
                if (item == null || item.getType() == null || item.getAmount() <= 0) continue;
                sanitized[i] = item.clone();
                continue;
            }
            catch (Exception e) {
                sanitized[i] = null;
            }
        }
        return sanitized;
    }

    public static int countItems(ItemStack[] items) {
        if (items == null) {
            return 0;
        }
        int count = 0;
        for (ItemStack item : items) {
            if (item == null) continue;
            ++count;
        }
        return count;
    }

    public static long calculateStorageSize(ItemStack[] items) {
        if (items == null) {
            return 0L;
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeInt(items.length);
                for (ItemStack item : items) {
                    dataOutput.writeObject((Object)item);
                }
            }
            return outputStream.size();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static String compressItemStackArray(ItemStack[] items) throws IOException {
        if (items == null) {
            return "";
        }
        return InventoryUtils.itemStackArrayToBase64(items);
    }

    public static ItemStack[] decompressItemStackArray(String data) throws IOException, ClassNotFoundException {
        if (data == null || data.isEmpty()) {
            return new ItemStack[0];
        }
        return InventoryUtils.itemStackArrayFromBase64(data);
    }

    public static ItemStack[] safeItemStackArrayFromBase64(String data) {
        if (data == null || data.isEmpty()) {
            return new ItemStack[0];
        }
        try {
            return InventoryUtils.itemStackArrayFromBase64(data);
        }
        catch (Exception e) {
            System.err.println("[PlayerDataSync] Failed to deserialize ItemStack array: " + InventoryUtils.collectCompatibilityMessage(e));
            return new ItemStack[0];
        }
    }

    public static ItemStack safeItemStackFromBase64(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            return InventoryUtils.itemStackFromBase64(data);
        }
        catch (Exception e) {
            System.err.println("[PlayerDataSync] Failed to deserialize single ItemStack: " + InventoryUtils.collectCompatibilityMessage(e));
            return null;
        }
    }

    private static boolean isVersionDowngradeIssue(Throwable throwable) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            String message = current.getMessage();
            if (message == null || !message.contains(NEWER_VERSION_FRAGMENT) && !message.contains(DOWNGRADE_ERROR_FRAGMENT)) continue;
            return true;
        }
        return false;
    }

    private static String collectCompatibilityMessage(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            String message = current.getMessage();
            if (message == null || message.isEmpty()) continue;
            if (!first) {
                builder.append(" | cause: ");
            }
            builder.append(message);
            first = false;
        }
        if (builder.length() == 0) {
            builder.append(throwable.getClass().getName());
        }
        return builder.toString();
    }
}

