/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import com.example.playerdatasync.AdvancementSyncManager;
import com.example.playerdatasync.ConfigManager;
import com.example.playerdatasync.InventoryUtils;
import com.example.playerdatasync.OfflinePlayerData;
import com.example.playerdatasync.PlayerDataCache;
import com.example.playerdatasync.PlayerDataSync;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DatabaseManager {
    private final PlayerDataSync plugin;
    private final PlayerDataCache cache;
    private long totalSaveTime = 0L;
    private long totalLoadTime = 0L;
    private int saveCount = 0;
    private int loadCount = 0;
    private long lastPerformanceLog = 0L;
    private final long PERFORMANCE_LOG_INTERVAL = 300000L;

    public DatabaseManager(PlayerDataSync plugin) {
        this.plugin = plugin;
        this.cache = new PlayerDataCache(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        String tableName = this.getTableName();
        String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (uuid VARCHAR(36) PRIMARY KEY,world VARCHAR(255),x DOUBLE,y DOUBLE,z DOUBLE,yaw FLOAT,pitch FLOAT,xp INT,gamemode VARCHAR(20),enderchest TEXT,inventory TEXT,armor TEXT,offhand TEXT,effects TEXT,statistics LONGTEXT,attributes TEXT,health DOUBLE,hunger INT,saturation FLOAT,advancements LONGTEXT,economy DOUBLE DEFAULT 0.0,last_save TIMESTAMP DEFAULT CURRENT_TIMESTAMP,server_id VARCHAR(50) DEFAULT 'default')";
        Connection connection = null;
        try {
            connection = this.plugin.getConnection();
            if (connection == null) {
                this.plugin.getLogger().severe("Database connection unavailable");
                return;
            }
            try (Statement st = connection.createStatement();){
                st.executeUpdate(sql);
                DatabaseMetaData meta = connection.getMetaData();
                try (ResultSet rs = meta.getColumns(null, null, tableName, "hunger");){
                    if (!rs.next()) {
                        st.executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN hunger INT");
                    }
                }
                rs = meta.getColumns(null, null, tableName, "saturation");
                try {
                    if (!rs.next()) {
                        st.executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN saturation FLOAT");
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = meta.getColumns(null, null, tableName, "advancements");
                try {
                    if (!rs.next()) {
                        st.executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN advancements LONGTEXT");
                    } else {
                        String dataType = rs.getString("TYPE_NAME");
                        if ("TEXT".equalsIgnoreCase(dataType)) {
                            try {
                                st.executeUpdate("ALTER TABLE " + tableName + " MODIFY COLUMN advancements LONGTEXT");
                                this.plugin.getLogger().info("Upgraded advancements column from TEXT to LONGTEXT");
                            }
                            catch (SQLException e) {
                                this.plugin.getLogger().warning("Could not upgrade advancements column to LONGTEXT: " + e.getMessage());
                            }
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                this.addColumnIfNotExists(meta, st, tableName, "armor", "TEXT");
                this.addColumnIfNotExists(meta, st, tableName, "offhand", "TEXT");
                this.addColumnIfNotExists(meta, st, tableName, "effects", "TEXT");
                this.addColumnIfNotExists(meta, st, tableName, "statistics", "LONGTEXT");
                this.addColumnIfNotExists(meta, st, tableName, "attributes", "TEXT");
                this.addColumnIfNotExists(meta, st, tableName, "economy", "DOUBLE DEFAULT 0.0");
                this.addColumnIfNotExists(meta, st, tableName, "last_save", "TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
                this.addColumnIfNotExists(meta, st, tableName, "server_id", "VARCHAR(50) DEFAULT 'default'");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not create table: " + e.getMessage());
        }
        finally {
            this.plugin.returnConnection(connection);
        }
    }

    private void addColumnIfNotExists(DatabaseMetaData meta, Statement st, String table, String columnName, String columnType) throws SQLException {
        try (ResultSet rs = meta.getColumns(null, null, table, columnName);){
            if (!rs.next()) {
                st.executeUpdate("ALTER TABLE " + table + " ADD COLUMN " + columnName + " " + columnType);
                this.plugin.getLogger().info("Added new column: " + columnName);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Could not add column " + columnName + ": " + e.getMessage());
        }
    }

    private String getTableName() {
        return this.plugin.getTablePrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePlayer(Player player) {
        boolean bl;
        Connection connection;
        block23: {
            PlayerSnapshot snapshot;
            long startTime = System.currentTimeMillis();
            String tableName = this.getTableName();
            String sql = "REPLACE INTO " + tableName + " (uuid, world, x, y, z, yaw, pitch, xp, gamemode, enderchest, inventory, armor, offhand, effects, statistics, attributes, health, hunger, saturation, advancements, economy, last_save, server_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            if (Bukkit.isPrimaryThread()) {
                snapshot = this.capturePlayerSnapshot(player);
            } else {
                Future future = Bukkit.getScheduler().callSyncMethod((Plugin)this.plugin, () -> this.capturePlayerSnapshot(player));
                snapshot = (PlayerSnapshot)future.get();
            }
            if (snapshot == null) {
                this.plugin.getLogger().warning("Skipping save for player " + player.getName() + " because snapshot creation failed");
                return false;
            }
            connection = this.plugin.getConnection();
            if (connection == null) {
                this.plugin.getLogger().severe("Database connection unavailable");
                return false;
            }
            PreparedStatement ps = connection.prepareStatement(sql);
            try {
                ps.setString(1, snapshot.uuid.toString());
                ps.setString(2, snapshot.worldName);
                ps.setDouble(3, snapshot.x);
                ps.setDouble(4, snapshot.y);
                ps.setDouble(5, snapshot.z);
                ps.setFloat(6, snapshot.yaw);
                ps.setFloat(7, snapshot.pitch);
                ps.setInt(8, snapshot.totalExperience);
                ps.setString(9, snapshot.gamemode);
                ps.setString(10, snapshot.enderChestData);
                ps.setString(11, snapshot.inventoryData);
                ps.setString(12, snapshot.armorData);
                ps.setString(13, snapshot.offhandData);
                ps.setString(14, snapshot.effectsData);
                ps.setString(15, snapshot.statisticsData);
                ps.setString(16, snapshot.attributesData);
                ps.setDouble(17, snapshot.health);
                ps.setInt(18, snapshot.hunger);
                ps.setFloat(19, snapshot.saturation);
                ps.setString(20, snapshot.advancementsData);
                ps.setDouble(21, snapshot.economyBalance);
                ps.setTimestamp(22, new Timestamp(System.currentTimeMillis()));
                ps.setString(23, this.plugin.getConfig().getString("server.id", "default"));
                ps.executeUpdate();
                long saveTime = System.currentTimeMillis() - startTime;
                this.totalSaveTime += saveTime;
                ++this.saveCount;
                if (saveTime > 1000L) {
                    this.plugin.getLogger().warning("Slow save detected for " + snapshot.playerName + ": " + saveTime + "ms");
                }
                this.logPerformanceStats();
                bl = true;
                if (ps == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        if (e.getMessage().contains("Data too long for column")) {
                            this.plugin.getLogger().severe("Data truncation error for " + snapshot.playerName + ": " + e.getMessage() + ". Consider disabling achievement sync or check your database column sizes.");
                        } else {
                            this.plugin.getLogger().severe("Could not save data for " + snapshot.playerName + ": " + e.getMessage());
                        }
                        boolean bl2 = false;
                        this.plugin.returnConnection(connection);
                        return bl2;
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        this.plugin.returnConnection(connection);
                        throw throwable3;
                    }
                    catch (InterruptedException e) {
                        this.plugin.getLogger().severe("Failed to capture data for player " + player.getName() + ": " + e.getMessage());
                        Thread.currentThread().interrupt();
                        return false;
                    }
                    catch (ExecutionException e) {
                        this.plugin.getLogger().severe("Failed to capture data for player " + player.getName() + ": " + e.getMessage());
                        return false;
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Unexpected error saving player " + player.getName() + ": " + e.getMessage());
                        return false;
                    }
                }
            }
            ps.close();
        }
        this.plugin.returnConnection(connection);
        return bl;
    }

    private PlayerSnapshot capturePlayerSnapshot(Player player) {
        PlayerSnapshot snapshot;
        block10: {
            snapshot = new PlayerSnapshot(player.getUniqueId(), player.getName());
            if (this.plugin.isSyncCoordinates() || this.plugin.isSyncPosition()) {
                Location loc = player.getLocation();
                World world = loc.getWorld();
                snapshot.worldName = world != null ? world.getName() : null;
                snapshot.x = loc.getX();
                snapshot.y = loc.getY();
                snapshot.z = loc.getZ();
                snapshot.yaw = loc.getYaw();
                snapshot.pitch = loc.getPitch();
            }
            snapshot.totalExperience = this.plugin.isSyncXp() ? player.getTotalExperience() : 0;
            snapshot.gamemode = this.plugin.isSyncGamemode() ? player.getGameMode().name() : null;
            try {
                snapshot.enderChestData = this.plugin.isSyncEnderchest() ? InventoryUtils.itemStackArrayToBase64(player.getEnderChest().getContents()) : null;
                snapshot.inventoryData = this.plugin.isSyncInventory() ? InventoryUtils.itemStackArrayToBase64(player.getInventory().getContents()) : null;
                snapshot.armorData = this.plugin.isSyncArmor() ? InventoryUtils.itemStackArrayToBase64(player.getInventory().getArmorContents()) : null;
                snapshot.offhandData = this.plugin.isSyncOffhand() ? InventoryUtils.itemStackToBase64(player.getInventory().getItemInOffHand()) : null;
                snapshot.effectsData = this.plugin.isSyncEffects() ? this.serializeEffects(player) : null;
                snapshot.statisticsData = this.plugin.isSyncStatistics() ? this.serializeStatistics(player) : null;
                snapshot.attributesData = this.plugin.isSyncAttributes() ? this.serializeAttributes(player) : null;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error serializing data for " + player.getName() + ": " + e.getMessage());
                snapshot.enderChestData = null;
                snapshot.inventoryData = null;
                snapshot.armorData = null;
                snapshot.offhandData = null;
                snapshot.effectsData = null;
                snapshot.statisticsData = null;
                snapshot.attributesData = null;
            }
            snapshot.health = this.plugin.isSyncHealth() ? player.getHealth() : player.getMaxHealth();
            snapshot.hunger = this.plugin.isSyncHunger() ? player.getFoodLevel() : 20;
            snapshot.saturation = this.plugin.isSyncHunger() ? player.getSaturation() : 5.0f;
            snapshot.advancementsData = null;
            if (this.plugin.isSyncAchievements()) {
                try {
                    long achievementStartTime = System.currentTimeMillis();
                    snapshot.advancementsData = this.serializeAdvancements(player);
                    long achievementTime = System.currentTimeMillis() - achievementStartTime;
                    if (achievementTime > 2000L) {
                        this.plugin.getLogger().warning("Slow achievement serialization for " + player.getName() + ": " + achievementTime + "ms. Consider disabling achievement sync for better performance.");
                    }
                    if (snapshot.advancementsData != null && snapshot.advancementsData.length() > 0xFFFFFF) {
                        this.plugin.getLogger().warning("Advancement data for " + player.getName() + " is too large (" + snapshot.advancementsData.length() + " characters), skipping advancement sync to prevent database errors");
                        snapshot.advancementsData = null;
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("CRITICAL: Achievement serialization failed for " + player.getName() + ". Disabling achievement sync to prevent server freeze: " + e.getMessage());
                    snapshot.advancementsData = null;
                    if (!this.plugin.getConfig().getBoolean("compatibility.disable_achievements_on_critical_error", true)) break block10;
                    this.plugin.getLogger().severe("CRITICAL: Automatically disabling achievement sync for " + player.getName() + " due to critical error. Set 'compatibility.disable_achievements_on_critical_error: false' to prevent this.");
                }
            }
        }
        if (this.plugin.isSyncEconomy()) {
            double balance;
            snapshot.economyBalance = balance = this.getPlayerBalance(player);
            this.plugin.logDebug("Saving economy balance for " + player.getName() + ": " + balance);
        } else {
            snapshot.economyBalance = 0.0;
            this.plugin.logDebug("Economy sync disabled, setting balance to 0.0 for " + player.getName());
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlayer(Player player) {
        long startTime = System.currentTimeMillis();
        String tableName = this.getTableName();
        String sql = "SELECT * FROM " + tableName + " WHERE uuid = ?";
        Connection connection = null;
        try {
            connection = this.plugin.getConnection();
            if (connection == null) {
                this.plugin.getLogger().severe("Database connection unavailable");
                return;
            }
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                block51: {
                    ps.setString(1, player.getUniqueId().toString());
                    try (ResultSet rs = ps.executeQuery();){
                        String attributesData;
                        String statsData;
                        String effectsData;
                        String offhandData;
                        String armorData;
                        ItemStack[] items;
                        String data;
                        String gm;
                        String worldName;
                        if (!rs.next()) break block51;
                        if ((this.plugin.isSyncCoordinates() || this.plugin.isSyncPosition()) && (worldName = rs.getString("world")) != null && !worldName.isEmpty()) {
                            World world = Bukkit.getWorld((String)worldName);
                            if (world != null) {
                                Location loc = new Location(world, rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("yaw"), rs.getFloat("pitch"));
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.teleport(loc));
                            } else {
                                this.plugin.getLogger().warning("World " + worldName + " not found when loading data for " + player.getName());
                            }
                        }
                        if (this.plugin.isSyncXp()) {
                            int xp = rs.getInt("xp");
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.applyExperience(player, xp));
                        }
                        if (this.plugin.isSyncGamemode() && (gm = rs.getString("gamemode")) != null) {
                            GameMode mode = GameMode.valueOf((String)gm);
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.setGameMode(mode));
                        }
                        if (this.plugin.isSyncEnderchest() && (data = rs.getString("enderchest")) != null) {
                            try {
                                items = InventoryUtils.safeItemStackArrayFromBase64(data);
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.getEnderChest().setContents(items));
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().severe("Error deserializing enderchest for " + player.getName() + ": " + e.getMessage());
                            }
                        }
                        if (this.plugin.isSyncInventory() && (data = rs.getString("inventory")) != null) {
                            try {
                                items = InventoryUtils.safeItemStackArrayFromBase64(data);
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.getInventory().setContents(items));
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().severe("Error deserializing inventory for " + player.getName() + ": " + e.getMessage());
                            }
                        }
                        if (this.plugin.isSyncHealth()) {
                            double health = rs.getDouble("health");
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.setHealth(Math.min(health, player.getMaxHealth())));
                        }
                        if (this.plugin.isSyncHunger()) {
                            int hunger = rs.getInt("hunger");
                            float saturation = rs.getFloat("saturation");
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                player.setFoodLevel(hunger);
                                player.setSaturation(saturation);
                            });
                        }
                        if (this.plugin.isSyncArmor() && (armorData = rs.getString("armor")) != null) {
                            try {
                                ItemStack[] armor = InventoryUtils.safeItemStackArrayFromBase64(armorData);
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.getInventory().setArmorContents(armor));
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().severe("Error deserializing armor for " + player.getName() + ": " + e.getMessage());
                            }
                        }
                        if (this.plugin.isSyncOffhand() && (offhandData = rs.getString("offhand")) != null) {
                            try {
                                ItemStack offhand = InventoryUtils.safeItemStackFromBase64(offhandData);
                                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.getInventory().setItemInOffHand(offhand));
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().severe("Error deserializing offhand for " + player.getName() + ": " + e.getMessage());
                            }
                        }
                        if (this.plugin.isSyncEffects() && (effectsData = rs.getString("effects")) != null) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.loadEffects(player, effectsData));
                        }
                        if (this.plugin.isSyncStatistics() && (statsData = rs.getString("statistics")) != null) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.loadStatistics(player, statsData));
                        }
                        if (this.plugin.isSyncAttributes() && (attributesData = rs.getString("attributes")) != null) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.loadAttributes(player, attributesData));
                        }
                        if (this.plugin.isSyncAchievements()) {
                            String advData = rs.getString("advancements");
                            AdvancementSyncManager advancementSyncManager = this.plugin.getAdvancementSyncManager();
                            if (advancementSyncManager != null) {
                                advancementSyncManager.seedFromDatabase(player.getUniqueId(), advData);
                                if (advData == null && this.plugin.getConfig().getBoolean("performance.automatic_player_advancement_import", true)) {
                                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> advancementSyncManager.queuePlayerImport(player, false));
                                }
                            }
                            if (advData != null && !advData.isEmpty()) {
                                String[] achievementKeys = advData.split(",");
                                if (achievementKeys.length > 200) {
                                    this.plugin.getLogger().warning("Large amount of achievements detected for " + player.getName() + " (" + achievementKeys.length + "). Loading in background to prevent server lag.");
                                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                                        try {
                                            this.loadAdvancements(player, advData);
                                        }
                                        catch (Exception e) {
                                            this.plugin.getLogger().severe("Error loading achievements for " + player.getName() + ": " + e.getMessage());
                                        }
                                    });
                                } else {
                                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.loadAdvancements(player, advData));
                                }
                            }
                        }
                        if (this.plugin.isSyncEconomy()) {
                            double balance = rs.getDouble("economy");
                            this.plugin.logDebug("Loading economy balance for " + player.getName() + ": " + balance);
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.setPlayerBalance(player, balance));
                        } else {
                            this.plugin.logDebug("Economy sync disabled, skipping balance load for " + player.getName());
                        }
                    }
                }
                long loadTime = System.currentTimeMillis() - startTime;
                this.totalLoadTime += loadTime;
                ++this.loadCount;
                if (loadTime > 2000L) {
                    this.plugin.getLogger().warning("Slow load detected for " + player.getName() + ": " + loadTime + "ms");
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not load data for " + player.getName() + ": " + e.getMessage());
            }
            finally {
                this.plugin.returnConnection(connection);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Unexpected error loading player " + player.getName() + ": " + e.getMessage());
        }
    }

    private void applyExperience(Player player, int total) {
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
        player.giveExp(total);
    }

    private String serializeAdvancements(Player player) {
        String serialized;
        AdvancementSyncManager advancementSyncManager = this.plugin.getAdvancementSyncManager();
        if (advancementSyncManager != null && (serialized = advancementSyncManager.serializeForSave(player)) != null) {
            return serialized;
        }
        return this.legacySerializeAdvancements(player);
    }

    private String legacySerializeAdvancements(Player player) {
        long startTime = System.currentTimeMillis();
        long TIMEOUT_MS = this.plugin.getConfig().getLong("performance.achievement_timeout_ms", 5000L);
        if (this.plugin.getConfig().getBoolean("performance.disable_achievement_sync_on_large_amounts", true)) {
            int totalAdvancements = 0;
            int MAX_COUNT_ATTEMPTS = 2000;
            try {
                Iterator it = Bukkit.getServer().advancementIterator();
                while (it.hasNext() && totalAdvancements < 2000) {
                    it.next();
                    if (++totalAdvancements % 50 != 0 || System.currentTimeMillis() - startTime <= TIMEOUT_MS) continue;
                    this.plugin.getLogger().severe("CRITICAL: Achievement counting timeout for " + player.getName() + " after " + totalAdvancements + " achievements. Aborting to prevent server freeze.");
                    return null;
                }
                if (totalAdvancements >= 2000) {
                    this.plugin.getLogger().severe("CRITICAL: Achievement counting hit hard limit (2000) for " + player.getName() + ". This indicates an infinite loop. Disabling achievement sync.");
                    return null;
                }
                if (totalAdvancements > 1500) {
                    this.plugin.getLogger().warning("Large amount of achievements detected (" + totalAdvancements + "). Achievement sync disabled for " + player.getName() + " to prevent server lag.");
                    return null;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not count achievements, proceeding with sync: " + e.getMessage());
            }
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int MAX_LENGTH = 0xFFFFFF;
        int MAX_ACHIEVEMENTS = this.plugin.getConfig().getInt("performance.max_achievements_per_player", 2000);
        try {
            ConfigManager configManager;
            Iterator it = Bukkit.getServer().advancementIterator();
            int processedCount = 0;
            int MAX_PROCESSED = 3000;
            while (it.hasNext() && count < MAX_ACHIEVEMENTS && processedCount < 3000) {
                ++processedCount;
                if (count % 25 == 0 && count > 0 && System.currentTimeMillis() - startTime > TIMEOUT_MS) {
                    this.plugin.getLogger().severe("CRITICAL: Achievement serialization timeout for " + player.getName() + " after " + count + " achievements. Aborting to prevent server freeze.");
                    break;
                }
                if (processedCount >= 3000) {
                    this.plugin.getLogger().severe("CRITICAL: Achievement processing hit hard limit (3000) for " + player.getName() + ". This indicates an infinite loop. Aborting.");
                    break;
                }
                Advancement adv = (Advancement)it.next();
                if (adv == null) {
                    this.plugin.getLogger().warning("Null advancement encountered, skipping...");
                    continue;
                }
                try {
                    AdvancementProgress progress = player.getAdvancementProgress(adv);
                    if (progress == null || !progress.isDone()) continue;
                    String key = adv.getKey().toString();
                    String toAdd = (sb.length() > 0 ? "," : "") + key;
                    if (sb.length() + toAdd.length() > 0xFFFFFF) {
                        this.plugin.getLogger().warning("Advancement data for " + player.getName() + " is too large, truncating at " + count + " achievements");
                        break;
                    }
                    sb.append(toAdd);
                    ++count;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error processing advancement for " + player.getName() + ": " + e.getMessage());
                }
            }
            if (count > 0 && (configManager = this.plugin.getConfigManager()) != null && configManager.isPerformanceLoggingEnabled()) {
                this.plugin.getLogger().info("Serialized " + count + " achievements for " + player.getName() + " in " + (System.currentTimeMillis() - startTime) + "ms");
            }
            if (count >= MAX_ACHIEVEMENTS) {
                this.plugin.getLogger().warning("CRITICAL: Hit maximum achievement limit (" + MAX_ACHIEVEMENTS + ") for " + player.getName() + ". This may indicate an infinite loop.");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error serializing achievements for " + player.getName() + ": " + e.getMessage());
            return null;
        }
        return sb.toString();
    }

    private String serializeEffects(Player player) {
        try {
            StringBuilder sb = new StringBuilder();
            for (PotionEffect effect : player.getActivePotionEffects()) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(effect.getType().getName()).append(",").append(effect.getAmplifier()).append(",").append(effect.getDuration()).append(",").append(effect.isAmbient()).append(",").append(effect.hasParticles()).append(",").append(effect.hasIcon());
            }
            return sb.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error serializing effects for " + player.getName() + ": " + e.getMessage());
            return null;
        }
    }

    private String serializeStatistics(Player player) {
        try {
            StringBuilder sb = new StringBuilder();
            for (Statistic stat : Statistic.values()) {
                try {
                    int value = player.getStatistic(stat);
                    if (value <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append(";");
                    }
                    sb.append(stat.name()).append(",").append(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error serializing statistics for " + player.getName() + ": " + e.getMessage());
            return null;
        }
    }

    private String serializeAttributes(Player player) {
        try {
            StringBuilder sb = new StringBuilder();
            boolean safeAttributeSync = this.plugin.getConfig().getBoolean("compatibility.safe_attribute_sync", true);
            if (safeAttributeSync) {
                try {
                    Object[] attributes;
                    Class<?> attributeClass = Class.forName("org.bukkit.attribute.Attribute");
                    for (Object attrObj : attributes = (Object[])attributeClass.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                        try {
                            String attrName = (String)attrObj.getClass().getMethod("name", new Class[0]).invoke(attrObj, new Object[0]);
                            AttributeInstance instance = player.getAttribute((Attribute)attrObj);
                            if (instance == null) continue;
                            if (sb.length() > 0) {
                                sb.append(";");
                            }
                            sb.append(attrName).append(",").append(instance.getBaseValue());
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().fine("Skipping attribute due to compatibility issue: " + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Reflection failed for attributes, using fallback method: " + e.getMessage());
                    for (Attribute attr : Attribute.values()) {
                        try {
                            AttributeInstance instance = player.getAttribute(attr);
                            if (instance == null) continue;
                            if (sb.length() > 0) {
                                sb.append(";");
                            }
                            sb.append(attr.name()).append(",").append(instance.getBaseValue());
                        }
                        catch (Exception ex) {
                            this.plugin.getLogger().fine("Skipping attribute " + attr.name() + ": " + ex.getMessage());
                        }
                    }
                }
            } else {
                for (Attribute attr : Attribute.values()) {
                    try {
                        AttributeInstance instance = player.getAttribute(attr);
                        if (instance == null) continue;
                        if (sb.length() > 0) {
                            sb.append(";");
                        }
                        sb.append(attr.name()).append(",").append(instance.getBaseValue());
                    }
                    catch (Exception ex) {
                        this.plugin.getLogger().fine("Skipping attribute " + attr.name() + ": " + ex.getMessage());
                    }
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error serializing attributes for " + player.getName() + ": " + e.getMessage());
            if (this.plugin.getConfig().getBoolean("compatibility.disable_attributes_on_error", false)) {
                this.plugin.getLogger().warning("Disabling attribute sync due to error. Set 'compatibility.disable_attributes_on_error: false' to prevent this.");
                this.plugin.setSyncAttributes(false);
            }
            return null;
        }
    }

    private void loadAdvancements(Player player, String data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        try {
            String[] keys = data.split(",");
            int totalKeys = keys.length;
            if (totalKeys > 100) {
                this.plugin.getLogger().info("Loading " + totalKeys + " achievements for " + player.getName() + " (this may take a moment for large amounts)");
            }
            int BATCH_SIZE = 50;
            for (int i = 0; i < keys.length; i += 50) {
                int batchStart = i;
                int batchEnd = Math.min(i + 50, keys.length);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    int batchLoaded = 0;
                    int batchFailed = 0;
                    for (int j = batchStart; j < batchEnd; ++j) {
                        String k = keys[j];
                        if (k.trim().isEmpty()) continue;
                        try {
                            NamespacedKey key = NamespacedKey.fromString((String)k.trim());
                            if (key == null) {
                                ++batchFailed;
                                continue;
                            }
                            Advancement adv = Bukkit.getAdvancement((NamespacedKey)key);
                            if (adv == null) {
                                ++batchFailed;
                                continue;
                            }
                            AdvancementProgress prog = player.getAdvancementProgress(adv);
                            if (prog.isDone()) continue;
                            for (String criterion : prog.getRemainingCriteria()) {
                                prog.awardCriteria(criterion);
                            }
                            ++batchLoaded;
                            continue;
                        }
                        catch (Exception e) {
                            ++batchFailed;
                            this.plugin.getLogger().warning("Failed to load advancement '" + k + "' for " + player.getName() + ": " + e.getMessage());
                        }
                    }
                    if (totalKeys > 100 && batchEnd >= totalKeys) {
                        this.plugin.getLogger().info("Finished loading achievements for " + player.getName() + ": " + batchLoaded + " loaded, " + batchFailed + " failed");
                    }
                }, (long)(i / 50) * 2L);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading achievements for " + player.getName() + ": " + e.getMessage());
        }
    }

    private void loadEffects(Player player, String data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        try {
            String[] effects;
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            for (String effectStr : effects = data.split(";")) {
                if (effectStr.trim().isEmpty()) continue;
                try {
                    PotionEffectType type;
                    String[] parts = effectStr.split(",");
                    if (parts.length < 6 || (type = PotionEffectType.getByName((String)parts[0])) == null) continue;
                    int amplifier = Integer.parseInt(parts[1]);
                    int duration = Integer.parseInt(parts[2]);
                    boolean ambient = Boolean.parseBoolean(parts[3]);
                    boolean particles = Boolean.parseBoolean(parts[4]);
                    boolean icon = Boolean.parseBoolean(parts[5]);
                    PotionEffect effect = new PotionEffect(type, duration, amplifier, ambient, particles, icon);
                    player.addPotionEffect(effect);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to load effect '" + effectStr + "' for " + player.getName() + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading effects for " + player.getName() + ": " + e.getMessage());
        }
    }

    private void loadStatistics(Player player, String data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        try {
            String[] stats;
            for (String statStr : stats = data.split(";")) {
                if (statStr.trim().isEmpty()) continue;
                try {
                    String[] parts = statStr.split(",");
                    if (parts.length < 2) continue;
                    Statistic stat = Statistic.valueOf((String)parts[0]);
                    int value = Integer.parseInt(parts[1]);
                    player.setStatistic(stat, value);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to load statistic '" + statStr + "' for " + player.getName() + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading statistics for " + player.getName() + ": " + e.getMessage());
        }
    }

    private void loadAttributes(Player player, String data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        try {
            String[] attributes;
            for (String attrStr : attributes = data.split(";")) {
                if (attrStr.trim().isEmpty()) continue;
                try {
                    String[] parts = attrStr.split(",");
                    if (parts.length < 2) continue;
                    Attribute attr = Attribute.valueOf((String)parts[0]);
                    double value = Double.parseDouble(parts[1]);
                    AttributeInstance instance = player.getAttribute(attr);
                    if (instance == null) continue;
                    instance.setBaseValue(value);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to load attribute '" + attrStr + "' for " + player.getName() + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error loading attributes for " + player.getName() + ": " + e.getMessage());
        }
    }

    private void logPerformanceStats() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPerformanceLog > 300000L) {
            this.lastPerformanceLog = currentTime;
            if (this.plugin.getConfigManager().isPerformanceLoggingEnabled()) {
                double avgSaveTime = this.saveCount > 0 ? (double)this.totalSaveTime / (double)this.saveCount : 0.0;
                double avgLoadTime = this.loadCount > 0 ? (double)this.totalLoadTime / (double)this.loadCount : 0.0;
                this.plugin.getLogger().info(String.format("Performance Stats - Saves: %d (avg: %.1fms), Loads: %d (avg: %.1fms)", this.saveCount, avgSaveTime, this.loadCount, avgLoadTime));
            }
        }
    }

    public String getPerformanceStats() {
        double avgSaveTime = this.saveCount > 0 ? (double)this.totalSaveTime / (double)this.saveCount : 0.0;
        double avgLoadTime = this.loadCount > 0 ? (double)this.totalLoadTime / (double)this.loadCount : 0.0;
        return String.format("Saves: %d (avg: %.1fms), Loads: %d (avg: %.1fms)", this.saveCount, avgSaveTime, this.loadCount, avgLoadTime);
    }

    public void resetPerformanceStats() {
        this.totalSaveTime = 0L;
        this.totalLoadTime = 0L;
        this.saveCount = 0;
        this.loadCount = 0;
        this.lastPerformanceLog = System.currentTimeMillis();
    }

    private double getPlayerBalance(Player player) {
        Economy economy = this.plugin.getEconomyProvider();
        if (economy == null) {
            this.plugin.getLogger().warning("Economy provider unavailable; skipping balance capture for " + player.getName());
            return 0.0;
        }
        try {
            if (!economy.hasAccount((OfflinePlayer)player)) {
                economy.createPlayerAccount((OfflinePlayer)player);
            }
            double balance = economy.getBalance((OfflinePlayer)player);
            this.plugin.logDebug("Retrieved balance for " + player.getName() + ": " + balance);
            return balance;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error getting player balance for " + player.getName() + ": " + e.getMessage());
            return 0.0;
        }
    }

    private void setPlayerBalance(Player player, double balance) {
        Economy economy = this.plugin.getEconomyProvider();
        if (economy == null) {
            this.plugin.getLogger().warning("Economy provider unavailable; skipping balance restore for " + player.getName());
            return;
        }
        this.plugin.logDebug("Attempting to set balance for " + player.getName() + " to " + balance);
        try {
            if (!economy.hasAccount((OfflinePlayer)player)) {
                economy.createPlayerAccount((OfflinePlayer)player);
            }
            this.plugin.logDebug("Economy provider found: " + economy.getName());
            try {
                Method setBalanceMethod = economy.getClass().getMethod("setBalance", OfflinePlayer.class, Double.TYPE);
                setBalanceMethod.invoke((Object)economy, player, balance);
                this.plugin.logDebug("Set balance for " + player.getName() + " to " + balance + " using setBalance method");
                return;
            }
            catch (NoSuchMethodException e) {
                this.plugin.logDebug("setBalance method not available, using deposit/withdraw approach");
            }
            catch (ReflectiveOperationException reflectiveError) {
                this.plugin.getLogger().warning("Failed to invoke setBalance on economy provider " + economy.getName() + ": " + reflectiveError.getMessage());
            }
            double currentBalance = economy.getBalance((OfflinePlayer)player);
            double difference = balance - currentBalance;
            this.plugin.logDebug("Current balance: " + currentBalance + ", Target balance: " + balance + ", Difference: " + difference);
            if (Math.abs(difference) < 0.01) {
                this.plugin.logDebug("Balance is already correct (within tolerance)");
                return;
            }
            if (difference > 0.0) {
                EconomyResponse response = economy.depositPlayer((OfflinePlayer)player, difference);
                if (!response.transactionSuccess()) {
                    this.plugin.getLogger().warning("Failed to deposit funds for " + player.getName() + ": " + response.errorMessage);
                    return;
                }
                this.plugin.logDebug("Added " + difference + " to " + player.getName() + "'s balance (now: " + balance + ")");
            } else {
                EconomyResponse response = economy.withdrawPlayer((OfflinePlayer)player, Math.abs(difference));
                if (!response.transactionSuccess()) {
                    this.plugin.getLogger().warning("Failed to withdraw funds for " + player.getName() + ": " + response.errorMessage);
                    return;
                }
                this.plugin.logDebug("Removed " + Math.abs(difference) + " from " + player.getName() + "'s balance (now: " + balance + ")");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error setting player balance for " + player.getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfflinePlayerData loadOfflinePlayerData(UUID uuid, String fallbackName) {
        String displayName;
        String string = displayName = fallbackName != null ? fallbackName : "unknown";
        if (uuid == null) {
            OfflinePlayerData empty = new OfflinePlayerData(null, displayName);
            empty.setInventoryContents(new ItemStack[36]);
            empty.setArmorContents(new ItemStack[4]);
            empty.setEnderChestContents(new ItemStack[27]);
            return empty;
        }
        String tableName = this.getTableName();
        String sql = "SELECT inventory, armor, offhand, enderchest FROM " + tableName + " WHERE uuid = ?";
        Connection connection = null;
        try {
            connection = this.plugin.getConnection();
            if (connection == null) {
                this.plugin.getLogger().severe("Database connection unavailable");
                OfflinePlayerData empty = new OfflinePlayerData(uuid, displayName);
                empty.setInventoryContents(new ItemStack[36]);
                empty.setArmorContents(new ItemStack[4]);
                empty.setEnderChestContents(new ItemStack[27]);
                OfflinePlayerData offlinePlayerData = empty;
                return offlinePlayerData;
            }
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                ps.setString(1, uuid.toString());
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        OfflinePlayerData data = new OfflinePlayerData(uuid, displayName);
                        data.setExistsInDatabase(true);
                        ItemStack[] combinedInventory = InventoryUtils.safeItemStackArrayFromBase64(rs.getString("inventory"));
                        data.setInventoryContents(this.extractMainInventory(combinedInventory));
                        ItemStack[] armor = InventoryUtils.safeItemStackArrayFromBase64(rs.getString("armor"));
                        if (armor.length == 0 && combinedInventory.length > 36) {
                            armor = new ItemStack[]{combinedInventory.length > 36 ? combinedInventory[36] : null, combinedInventory.length > 37 ? combinedInventory[37] : null, combinedInventory.length > 38 ? combinedInventory[38] : null, combinedInventory.length > 39 ? combinedInventory[39] : null};
                        }
                        data.setArmorContents(this.normalizeArmorArray(armor));
                        ItemStack offhand = InventoryUtils.safeItemStackFromBase64(rs.getString("offhand"));
                        if (offhand == null && combinedInventory.length > 40) {
                            offhand = combinedInventory[40];
                        }
                        data.setOffhandItem(offhand);
                        ItemStack[] enderChest = InventoryUtils.safeItemStackArrayFromBase64(rs.getString("enderchest"));
                        data.setEnderChestContents(enderChest);
                        OfflinePlayerData offlinePlayerData = data;
                        return offlinePlayerData;
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error loading offline data for " + displayName + ": " + e.getMessage());
        }
        finally {
            this.plugin.returnConnection(connection);
        }
        OfflinePlayerData emptyData = new OfflinePlayerData(uuid, displayName);
        emptyData.setInventoryContents(new ItemStack[36]);
        emptyData.setArmorContents(new ItemStack[4]);
        emptyData.setEnderChestContents(new ItemStack[27]);
        return emptyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveOfflineInventoryData(OfflinePlayerData data) {
        if (data == null || data.getUuid() == null) {
            return false;
        }
        Connection connection = null;
        try {
            PreparedStatement ps;
            connection = this.plugin.getConnection();
            if (connection == null) {
                this.plugin.getLogger().severe("Database connection unavailable");
                boolean bl = false;
                return bl;
            }
            ItemStack[] main = data.getInventoryContents();
            ItemStack[] armor = this.normalizeArmorArray(data.getArmorContents());
            ItemStack offhand = data.getOffhandItem();
            ItemStack[] combined = this.combineInventoryAndEquipment(main, armor, offhand);
            String inventoryData = InventoryUtils.itemStackArrayToBase64(combined);
            String armorData = InventoryUtils.itemStackArrayToBase64(armor);
            String offhandData = offhand != null ? InventoryUtils.itemStackToBase64(offhand) : "";
            String tableName = this.getTableName();
            String serverId = this.plugin.getConfig().getString("server.id", "default");
            if (data.existsInDatabase()) {
                String updateSql = "UPDATE " + tableName + " SET inventory=?, armor=?, offhand=?, last_save=CURRENT_TIMESTAMP, server_id=? WHERE uuid=?";
                ps = connection.prepareStatement(updateSql);
                try {
                    ps.setString(1, inventoryData);
                    ps.setString(2, armorData);
                    ps.setString(3, offhandData);
                    ps.setString(4, serverId);
                    ps.setString(5, data.getUuid().toString());
                    if (ps.executeUpdate() > 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            String insertSql = "INSERT INTO " + tableName + " (uuid, inventory, armor, offhand, server_id) VALUES (?,?,?,?,?)";
            ps = connection.prepareStatement(insertSql);
            try {
                ps.setString(1, data.getUuid().toString());
                ps.setString(2, inventoryData);
                ps.setString(3, armorData);
                ps.setString(4, offhandData);
                ps.setString(5, serverId);
                if (ps.executeUpdate() > 0) {
                    data.setExistsInDatabase(true);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (IOException | SQLException e) {
            this.plugin.getLogger().severe("Error saving offline inventory for " + data.getDisplayName() + ": " + e.getMessage());
        }
        finally {
            this.plugin.returnConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveOfflineEnderChestData(OfflinePlayerData data) {
        if (data == null || data.getUuid() == null) {
            return false;
        }
        Connection connection = null;
        try {
            PreparedStatement ps;
            connection = this.plugin.getConnection();
            if (connection == null) {
                this.plugin.getLogger().severe("Database connection unavailable");
                boolean bl = false;
                return bl;
            }
            ItemStack[] contents = data.getEnderChestContents();
            String enderData = InventoryUtils.itemStackArrayToBase64(contents != null ? contents : new ItemStack[]{});
            String tableName = this.getTableName();
            String serverId = this.plugin.getConfig().getString("server.id", "default");
            if (data.existsInDatabase()) {
                String updateSql = "UPDATE " + tableName + " SET enderchest=?, last_save=CURRENT_TIMESTAMP, server_id=? WHERE uuid=?";
                ps = connection.prepareStatement(updateSql);
                try {
                    ps.setString(1, enderData);
                    ps.setString(2, serverId);
                    ps.setString(3, data.getUuid().toString());
                    if (ps.executeUpdate() > 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            String insertSql = "INSERT INTO " + tableName + " (uuid, enderchest, server_id) VALUES (?,?,?)";
            ps = connection.prepareStatement(insertSql);
            try {
                ps.setString(1, data.getUuid().toString());
                ps.setString(2, enderData);
                ps.setString(3, serverId);
                if (ps.executeUpdate() > 0) {
                    data.setExistsInDatabase(true);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (IOException | SQLException e) {
            this.plugin.getLogger().severe("Error saving offline ender chest for " + data.getDisplayName() + ": " + e.getMessage());
        }
        finally {
            this.plugin.returnConnection(connection);
        }
        return false;
    }

    private ItemStack[] extractMainInventory(ItemStack[] combined) {
        ItemStack[] main = new ItemStack[36];
        if (combined != null) {
            System.arraycopy(combined, 0, main, 0, Math.min(combined.length, 36));
        }
        return main;
    }

    private ItemStack[] normalizeArmorArray(ItemStack[] armor) {
        ItemStack[] normalized = new ItemStack[4];
        if (armor != null) {
            for (int i = 0; i < Math.min(armor.length, 4); ++i) {
                normalized[i] = armor[i];
            }
        }
        return normalized;
    }

    private ItemStack[] combineInventoryAndEquipment(ItemStack[] main, ItemStack[] armor, ItemStack offhand) {
        ItemStack[] combined = new ItemStack[41];
        for (int i = 0; i < 36; ++i) {
            combined[i] = main != null && i < main.length ? main[i] : null;
        }
        ItemStack[] normalizedArmor = this.normalizeArmorArray(armor);
        combined[36] = normalizedArmor[0];
        combined[37] = normalizedArmor[1];
        combined[38] = normalizedArmor[2];
        combined[39] = normalizedArmor[3];
        combined[40] = offhand;
        return combined;
    }

    private static class PlayerSnapshot {
        private final UUID uuid;
        private final String playerName;
        private String worldName = null;
        private double x = 0.0;
        private double y = 0.0;
        private double z = 0.0;
        private float yaw = 0.0f;
        private float pitch = 0.0f;
        private int totalExperience = 0;
        private String gamemode = null;
        private String enderChestData = null;
        private String inventoryData = null;
        private String armorData = null;
        private String offhandData = null;
        private String effectsData = null;
        private String statisticsData = null;
        private String attributesData = null;
        private double health = 20.0;
        private int hunger = 20;
        private float saturation = 5.0f;
        private String advancementsData = null;
        private double economyBalance = 0.0;

        private PlayerSnapshot(UUID uuid, String playerName) {
            this.uuid = uuid;
            this.playerName = playerName;
        }
    }
}

