/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import com.example.playerdatasync.PlayerDataSync;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final PlayerDataSync plugin;
    private FileConfiguration config;
    private File configFile;
    private static final int CURRENT_CONFIG_VERSION = 6;

    public ConfigManager(PlayerDataSync plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        this.validateAndMigrateConfig();
    }

    private void validateAndMigrateConfig() {
        if (this.config.getKeys(false).isEmpty()) {
            this.plugin.getLogger().severe("Configuration file is completely empty! This indicates a serious problem.");
            this.plugin.getLogger().severe("Please check if the plugin JAR file is corrupted or if there are permission issues.");
            return;
        }
        int configVersion = this.config.getInt("config-version", 1);
        if (configVersion < 6) {
            this.plugin.getLogger().info("Migrating configuration from version " + configVersion + " to 6");
            this.migrateConfig(configVersion);
        }
        this.validateConfiguration();
        this.config.set("config-version", (Object)6);
        this.saveConfig();
    }

    private void migrateConfig(int fromVersion) {
        try {
            if (fromVersion < 2) {
                this.migrateFromV1ToV2();
                fromVersion = 2;
            }
            if (fromVersion < 3) {
                this.migrateFromV2ToV3();
                fromVersion = 3;
            }
            if (fromVersion < 4) {
                this.migrateFromV3ToV4();
                fromVersion = 4;
            }
            if (fromVersion < 5) {
                this.migrateFromV4ToV5();
                fromVersion = 5;
            }
            if (fromVersion < 6) {
                this.migrateFromV5ToV6();
            }
            this.plugin.getLogger().info("Configuration migration completed successfully.");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Configuration migration failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void migrateFromV1ToV2() {
        if (this.config.contains("language")) {
            String language = this.config.getString("language", "en");
            this.config.set("messages.language", (Object)language);
            this.config.set("language", null);
        }
        if (this.config.contains("metrics")) {
            boolean metrics = this.config.getBoolean("metrics", true);
            this.config.set("metrics.bstats", (Object)metrics);
            this.config.set("metrics", null);
        }
        this.addDefaultIfMissing("autosave.enabled", true);
        this.addDefaultIfMissing("autosave.on_world_change", true);
        this.addDefaultIfMissing("autosave.on_death", true);
        this.addDefaultIfMissing("autosave.async", true);
        this.addDefaultIfMissing("performance.batch_size", 50);
        this.addDefaultIfMissing("performance.cache_size", 100);
        this.addDefaultIfMissing("performance.connection_pooling", true);
        this.addDefaultIfMissing("performance.async_loading", true);
        this.addDefaultIfMissing("security.encrypt_data", false);
        this.addDefaultIfMissing("security.hash_uuids", false);
        this.addDefaultIfMissing("security.audit_log", true);
        this.addDefaultIfMissing("logging.level", "INFO");
        this.addDefaultIfMissing("logging.log_database", false);
        this.addDefaultIfMissing("logging.log_performance", false);
        this.addDefaultIfMissing("logging.debug_mode", false);
    }

    private void migrateFromV2ToV3() {
        this.addDefaultIfMissing("database.table_prefix", "player_data");
        String prefix = this.config.getString("database.table_prefix", "player_data");
        String sanitized = this.sanitizeTablePrefix(prefix);
        if (!sanitized.equals(prefix)) {
            this.config.set("database.table_prefix", (Object)sanitized);
            this.plugin.getLogger().info("Sanitized database.table_prefix from '" + prefix + "' to '" + sanitized + "'.");
        }
    }

    private void migrateFromV3ToV4() {
    }

    private void migrateFromV4ToV5() {
        if (this.config.contains("editor")) {
            this.plugin.getLogger().info("Removing deprecated editor.* configuration entries.");
            this.config.set("editor", null);
        }
    }

    private void migrateFromV5ToV6() {
        this.addDefaultIfMissing("integrations.invsee", true);
        this.addDefaultIfMissing("integrations.openinv", true);
    }

    public void initializeDefaultConfig() {
        this.plugin.getLogger().info("Initializing default configuration...");
        this.addDefaultIfMissing("config-version", 6);
        this.addDefaultIfMissing("server.id", "default");
        this.addDefaultIfMissing("database.type", "mysql");
        this.addDefaultIfMissing("database.mysql.host", "localhost");
        this.addDefaultIfMissing("database.mysql.port", 3306);
        this.addDefaultIfMissing("database.mysql.database", "minecraft");
        this.addDefaultIfMissing("database.mysql.user", "root");
        this.addDefaultIfMissing("database.mysql.password", "password");
        this.addDefaultIfMissing("database.mysql.ssl", false);
        this.addDefaultIfMissing("database.mysql.connection_timeout", 5000);
        this.addDefaultIfMissing("database.mysql.max_connections", 10);
        this.addDefaultIfMissing("database.table_prefix", "player_data");
        this.addDefaultIfMissing("database.sqlite.file", "plugins/PlayerDataSync/playerdata.db");
        this.addDefaultIfMissing("sync.coordinates", true);
        this.addDefaultIfMissing("sync.position", true);
        this.addDefaultIfMissing("sync.xp", true);
        this.addDefaultIfMissing("sync.gamemode", true);
        this.addDefaultIfMissing("sync.inventory", true);
        this.addDefaultIfMissing("sync.enderchest", true);
        this.addDefaultIfMissing("sync.armor", true);
        this.addDefaultIfMissing("sync.offhand", true);
        this.addDefaultIfMissing("sync.health", true);
        this.addDefaultIfMissing("sync.hunger", true);
        this.addDefaultIfMissing("sync.effects", true);
        this.addDefaultIfMissing("sync.achievements", true);
        this.addDefaultIfMissing("sync.statistics", true);
        this.addDefaultIfMissing("sync.attributes", true);
        this.addDefaultIfMissing("sync.permissions", false);
        this.addDefaultIfMissing("sync.economy", false);
        this.addDefaultIfMissing("autosave.enabled", true);
        this.addDefaultIfMissing("autosave.interval", 1);
        this.addDefaultIfMissing("autosave.on_world_change", true);
        this.addDefaultIfMissing("autosave.on_death", true);
        this.addDefaultIfMissing("autosave.async", true);
        this.addDefaultIfMissing("performance.batch_size", 50);
        this.addDefaultIfMissing("performance.cache_size", 100);
        this.addDefaultIfMissing("performance.cache_ttl", 300000);
        this.addDefaultIfMissing("performance.cache_compression", true);
        this.addDefaultIfMissing("performance.connection_pooling", true);
        this.addDefaultIfMissing("performance.async_loading", true);
        this.addDefaultIfMissing("performance.disable_achievement_sync_on_large_amounts", true);
        this.addDefaultIfMissing("performance.achievement_batch_size", 50);
        this.addDefaultIfMissing("performance.achievement_timeout_ms", 5000);
        this.addDefaultIfMissing("performance.max_achievements_per_player", 2000);
        this.addDefaultIfMissing("performance.preload_advancements_on_startup", true);
        this.addDefaultIfMissing("performance.advancement_import_batch_size", 250);
        this.addDefaultIfMissing("performance.player_advancement_import_batch_size", 150);
        this.addDefaultIfMissing("performance.automatic_player_advancement_import", true);
        this.addDefaultIfMissing("compatibility.safe_attribute_sync", true);
        this.addDefaultIfMissing("compatibility.disable_attributes_on_error", false);
        this.addDefaultIfMissing("compatibility.version_check", true);
        this.addDefaultIfMissing("compatibility.legacy_1_20_support", true);
        this.addDefaultIfMissing("compatibility.modern_1_21_support", true);
        this.addDefaultIfMissing("compatibility.disable_achievements_on_critical_error", true);
        this.addDefaultIfMissing("security.encrypt_data", false);
        this.addDefaultIfMissing("security.hash_uuids", false);
        this.addDefaultIfMissing("security.audit_log", true);
        this.addDefaultIfMissing("logging.level", "INFO");
        this.addDefaultIfMissing("logging.log_database", false);
        this.addDefaultIfMissing("logging.log_performance", false);
        this.addDefaultIfMissing("logging.debug_mode", false);
        this.addDefaultIfMissing("update_checker.enabled", true);
        this.addDefaultIfMissing("update_checker.notify_ops", true);
        this.addDefaultIfMissing("update_checker.auto_download", false);
        this.addDefaultIfMissing("update_checker.timeout", 10000);
        this.addDefaultIfMissing("metrics.bstats", true);
        this.addDefaultIfMissing("metrics.custom_metrics", true);
        this.addDefaultIfMissing("integrations.invsee", true);
        this.addDefaultIfMissing("integrations.openinv", true);
        this.addDefaultIfMissing("messages.enabled", true);
        this.addDefaultIfMissing("messages.language", "en");
        this.addDefaultIfMissing("messages.prefix", "&8[&bPDS&8]");
        this.addDefaultIfMissing("messages.colors", true);
        this.plugin.getLogger().info("Default configuration initialized successfully!");
    }

    private void addDefaultIfMissing(String path, Object defaultValue) {
        if (!this.config.contains(path)) {
            this.config.set(path, defaultValue);
        }
    }

    private void validateConfiguration() {
        String logLevelRaw;
        Level resolvedLevel;
        int batchSize;
        int cacheSize;
        int interval;
        String tablePrefix;
        String sanitizedPrefix;
        ArrayList<Object> warnings = new ArrayList<Object>();
        String dbType = this.config.getString("database.type", "mysql").toLowerCase();
        if (!(dbType.equals("mysql") || dbType.equals("sqlite") || dbType.equals("postgresql"))) {
            warnings.add("Invalid database type: " + dbType + ". Using MySQL as default.");
            this.config.set("database.type", (Object)"mysql");
        }
        if ((sanitizedPrefix = this.sanitizeTablePrefix(tablePrefix = this.config.getString("database.table_prefix", "player_data"))).isEmpty()) {
            warnings.add("database.table_prefix is empty or invalid. Using default 'player_data'.");
            sanitizedPrefix = "player_data";
        }
        if (!sanitizedPrefix.equals(tablePrefix)) {
            warnings.add("Sanitized database.table_prefix from '" + tablePrefix + "' to '" + sanitizedPrefix + "'.");
            this.config.set("database.table_prefix", (Object)sanitizedPrefix);
        }
        if ((interval = this.config.getInt("autosave.interval", 1)) < 0) {
            warnings.add("Invalid autosave interval: " + interval + ". Using 1 second as default.");
            this.config.set("autosave.interval", (Object)1);
        }
        if ((cacheSize = this.config.getInt("performance.cache_size", 100)) < 10 || cacheSize > 10000) {
            warnings.add("Invalid cache size: " + cacheSize + ". Using 100 as default.");
            this.config.set("performance.cache_size", (Object)100);
        }
        if ((batchSize = this.config.getInt("performance.batch_size", 50)) < 1 || batchSize > 1000) {
            warnings.add("Invalid batch size: " + batchSize + ". Using 50 as default.");
            this.config.set("performance.batch_size", (Object)50);
        }
        if ((resolvedLevel = this.parseLogLevel(logLevelRaw = this.config.getString("logging.level", "INFO"))) == null) {
            warnings.add("Invalid logging level: " + logLevelRaw + ". Using INFO as default.");
            this.config.set("logging.level", (Object)"INFO");
        } else {
            this.config.set("logging.level", (Object)resolvedLevel.getName());
        }
        if (!warnings.isEmpty()) {
            this.plugin.getLogger().warning("Configuration validation found issues:");
            for (String string : warnings) {
                this.plugin.getLogger().warning("- " + string);
            }
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save configuration: " + e.getMessage());
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.validateAndMigrateConfig();
    }

    public <T> T get(String path, T defaultValue, Class<T> type) {
        Object value = this.config.get(path, defaultValue);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        this.plugin.getLogger().warning("Configuration value at '" + path + "' is not of expected type " + type.getSimpleName());
        return defaultValue;
    }

    public boolean isDebugMode() {
        return this.config.getBoolean("logging.debug_mode", false);
    }

    public String getTablePrefix() {
        return this.sanitizeTablePrefix(this.config.getString("database.table_prefix", "player_data"));
    }

    public boolean isDatabaseLoggingEnabled() {
        return this.config.getBoolean("logging.log_database", false);
    }

    private String sanitizeTablePrefix(String prefix) {
        if (prefix == null) {
            return "player_data";
        }
        String sanitized = prefix.trim().replaceAll("[^a-zA-Z0-9_]", "_");
        if (sanitized.isEmpty()) {
            return "player_data";
        }
        return sanitized;
    }

    public boolean isPerformanceLoggingEnabled() {
        return this.config.getBoolean("logging.log_performance", false);
    }

    public String getServerId() {
        return this.config.getString("server.id", "default");
    }

    public Level getLoggingLevel() {
        Level level = this.parseLogLevel(this.config.getString("logging.level", "INFO"));
        return level != null ? level : Level.INFO;
    }

    private Level parseLogLevel(String levelStr) {
        String normalized;
        if (levelStr == null) {
            return null;
        }
        switch (normalized = levelStr.trim().toUpperCase(Locale.ROOT)) {
            case "WARN": 
            case "WARNING": {
                return Level.WARNING;
            }
            case "ERROR": 
            case "SEVERE": {
                return Level.SEVERE;
            }
            case "DEBUG": 
            case "FINE": {
                return Level.FINE;
            }
            case "TRACE": 
            case "FINER": {
                return Level.FINER;
            }
            case "FINEST": {
                return Level.FINEST;
            }
            case "CONFIG": {
                return Level.CONFIG;
            }
            case "ALL": {
                return Level.ALL;
            }
            case "OFF": {
                return Level.OFF;
            }
            case "INFO": {
                return Level.INFO;
            }
        }
        try {
            return Level.parse(normalized);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public boolean isFeatureEnabled(String feature) {
        return this.config.getBoolean("sync." + feature, true);
    }

    public boolean isEncryptionEnabled() {
        return this.config.getBoolean("security.encrypt_data", false);
    }

    public boolean isUuidHashingEnabled() {
        return this.config.getBoolean("security.hash_uuids", false);
    }

    public boolean isAuditLogEnabled() {
        return this.config.getBoolean("security.audit_log", true);
    }

    public boolean isCleanupEnabled() {
        return this.config.getBoolean("data_management.cleanup.enabled", false);
    }

    public int getCleanupDays() {
        return this.config.getInt("data_management.cleanup.days_inactive", 90);
    }

    public boolean isBackupEnabled() {
        return this.config.getBoolean("data_management.backup.enabled", true);
    }

    public int getBackupInterval() {
        return this.config.getInt("data_management.backup.interval", 1440);
    }

    public int getBackupsToKeep() {
        return this.config.getInt("data_management.backup.keep_backups", 7);
    }

    public boolean isValidationEnabled() {
        return this.config.getBoolean("data_management.validation.enabled", true);
    }

    public boolean isStrictValidation() {
        return this.config.getBoolean("data_management.validation.strict_mode", false);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

