/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync;

import com.example.playerdatasync.PlayerDataSync;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AdvancementSyncManager
implements Listener {
    private final PlayerDataSync plugin;
    private final Map<UUID, PlayerAdvancementState> states = new ConcurrentHashMap<UUID, PlayerAdvancementState>();
    private final CopyOnWriteArrayList<NamespacedKey> cachedAdvancements = new CopyOnWriteArrayList();
    private volatile boolean globalImportRunning = false;
    private volatile boolean globalImportCompleted = false;
    private BukkitTask globalImportTask;

    public AdvancementSyncManager(PlayerDataSync plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        if (plugin.getConfig().getBoolean("performance.preload_advancements_on_startup", true)) {
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> this.startGlobalImport(false));
        }
    }

    public void shutdown() {
        if (this.globalImportTask != null) {
            this.globalImportTask.cancel();
            this.globalImportTask = null;
        }
    }

    public void reloadFromConfig() {
        if (this.plugin.getConfig().getBoolean("performance.preload_advancements_on_startup", true) && !this.globalImportCompleted && !this.globalImportRunning) {
            this.startGlobalImport(false);
        }
    }

    @EventHandler
    public void onAdvancementCompleted(PlayerAdvancementDoneEvent event) {
        Advancement advancement = event.getAdvancement();
        if (advancement == null) {
            return;
        }
        this.recordAdvancement(event.getPlayer().getUniqueId(), advancement.getKey().toString());
    }

    public void recordAdvancement(UUID uuid, String key) {
        PlayerAdvancementState state = this.states.computeIfAbsent(uuid, id -> new PlayerAdvancementState());
        state.completedAdvancements.add(key);
        if (state.importInProgress) {
            state.pendingDuringImport.add(key);
        }
        state.lastUpdated = System.currentTimeMillis();
    }

    public void handlePlayerJoin(Player player) {
        if (!this.plugin.getConfig().getBoolean("performance.automatic_player_advancement_import", true)) {
            return;
        }
        PlayerAdvancementState state = this.states.computeIfAbsent(player.getUniqueId(), key -> new PlayerAdvancementState());
        if (state.importFinished || state.importInProgress) {
            return;
        }
        this.queuePlayerImport(player, false);
    }

    public void handlePlayerQuit(Player player) {
        PlayerAdvancementState state = this.states.get(player.getUniqueId());
        if (state != null) {
            state.importInProgress = false;
        }
    }

    public void seedFromDatabase(UUID uuid, String csv) {
        PlayerAdvancementState state = this.states.computeIfAbsent(uuid, key -> new PlayerAdvancementState());
        state.completedAdvancements.clear();
        state.pendingDuringImport.clear();
        if (csv == null) {
            state.importFinished = false;
            state.lastUpdated = System.currentTimeMillis();
            return;
        }
        if (!csv.isEmpty()) {
            String[] parts;
            for (String part : parts = csv.split(",")) {
                String trimmed = part.trim();
                if (trimmed.isEmpty()) continue;
                state.completedAdvancements.add(trimmed);
            }
        }
        state.importFinished = true;
        state.lastUpdated = System.currentTimeMillis();
    }

    public void forgetPlayer(UUID uuid) {
        this.states.remove(uuid);
    }

    public String serializeForSave(Player player) {
        PlayerAdvancementState state = this.states.computeIfAbsent(player.getUniqueId(), key -> new PlayerAdvancementState());
        if (!state.importFinished && !state.importInProgress && this.plugin.getConfig().getBoolean("performance.automatic_player_advancement_import", true)) {
            this.queuePlayerImport(player, false);
        }
        if (state.completedAdvancements.isEmpty()) {
            return "";
        }
        return state.completedAdvancements.stream().sorted().collect(Collectors.joining(","));
    }

    public void queuePlayerImport(final Player player, boolean force) {
        final PlayerAdvancementState state = this.states.computeIfAbsent(player.getUniqueId(), key -> new PlayerAdvancementState());
        if (!force ? state.importInProgress || state.importFinished : state.importInProgress) {
            return;
        }
        List<NamespacedKey> keys = this.getCachedAdvancementKeys();
        if (keys.isEmpty()) {
            if (this.globalImportRunning || !this.globalImportCompleted) {
                if (!state.awaitingGlobalCache) {
                    state.importInProgress = true;
                    state.awaitingGlobalCache = true;
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        state.importInProgress = false;
                        state.awaitingGlobalCache = false;
                        if (player.isOnline()) {
                            this.queuePlayerImport(player, force);
                        }
                    }, 20L);
                }
                return;
            }
            state.importFinished = true;
            state.importInProgress = false;
            return;
        }
        final int batchSize = Math.max(1, this.plugin.getConfig().getInt("performance.player_advancement_import_batch_size", 150));
        state.importInProgress = true;
        state.pendingDuringImport.clear();
        state.lastImportStart = System.currentTimeMillis();
        final Iterator<NamespacedKey> iterator = keys.iterator();
        final HashSet imported = new HashSet();
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    state.importInProgress = false;
                    this.cancel();
                    return;
                }
                for (int processed = 0; iterator.hasNext() && processed < batchSize; ++processed) {
                    AdvancementProgress progress;
                    NamespacedKey key = (NamespacedKey)iterator.next();
                    Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
                    if (advancement == null || (progress = player.getAdvancementProgress(advancement)) == null || !progress.isDone()) continue;
                    imported.add(key.toString());
                }
                if (!iterator.hasNext()) {
                    state.completedAdvancements.clear();
                    state.completedAdvancements.addAll(imported);
                    if (!state.pendingDuringImport.isEmpty()) {
                        state.completedAdvancements.addAll(state.pendingDuringImport);
                        state.pendingDuringImport.clear();
                    }
                    state.importFinished = true;
                    state.importInProgress = false;
                    state.lastImportDuration = System.currentTimeMillis() - state.lastImportStart;
                    state.lastUpdated = System.currentTimeMillis();
                    if (AdvancementSyncManager.this.plugin.isPerformanceLoggingEnabled()) {
                        AdvancementSyncManager.this.plugin.getLogger().info("Imported " + state.completedAdvancements.size() + " achievements for " + player.getName() + " in " + state.lastImportDuration + "ms");
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    public boolean startGlobalImport(boolean force) {
        if (this.globalImportRunning) {
            return false;
        }
        if (this.globalImportCompleted && !force) {
            return false;
        }
        final Iterator iterator = Bukkit.getServer().advancementIterator();
        this.cachedAdvancements.clear();
        this.globalImportRunning = true;
        this.globalImportCompleted = false;
        final int batchSize = Math.max(1, this.plugin.getConfig().getInt("performance.advancement_import_batch_size", 250));
        this.globalImportTask = new BukkitRunnable(){

            public void run() {
                for (int processed = 0; iterator.hasNext() && processed < batchSize; ++processed) {
                    Advancement advancement = (Advancement)iterator.next();
                    if (advancement == null) continue;
                    AdvancementSyncManager.this.cachedAdvancements.add(advancement.getKey());
                }
                if (!iterator.hasNext()) {
                    AdvancementSyncManager.this.globalImportRunning = false;
                    AdvancementSyncManager.this.globalImportCompleted = true;
                    if (AdvancementSyncManager.this.plugin.isPerformanceLoggingEnabled()) {
                        AdvancementSyncManager.this.plugin.getLogger().info("Cached " + AdvancementSyncManager.this.cachedAdvancements.size() + " advancement definitions for staged synchronization");
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        return true;
    }

    public List<NamespacedKey> getCachedAdvancementKeys() {
        if (this.cachedAdvancements.isEmpty() && !this.globalImportRunning) {
            this.startGlobalImport(false);
        }
        return new ArrayList<NamespacedKey>(this.cachedAdvancements);
    }

    public String getGlobalImportStatus() {
        if (this.globalImportRunning) {
            return "running (" + this.cachedAdvancements.size() + " cached so far)";
        }
        if (this.globalImportCompleted) {
            return "ready (" + this.cachedAdvancements.size() + " cached)";
        }
        return "not started";
    }

    public String getPlayerStatus(UUID uuid) {
        PlayerAdvancementState state = this.states.get(uuid);
        if (state == null) {
            return "no data";
        }
        if (state.importInProgress) {
            return "importing (" + state.completedAdvancements.size() + " known so far)";
        }
        if (state.importFinished) {
            return "ready (" + state.completedAdvancements.size() + " cached)";
        }
        return "pending import";
    }

    public void forceRescan(Player player) {
        this.queuePlayerImport(player, true);
    }

    private static class PlayerAdvancementState {
        private final Set<String> completedAdvancements = ConcurrentHashMap.newKeySet();
        private final Set<String> pendingDuringImport = ConcurrentHashMap.newKeySet();
        private volatile boolean importFinished = false;
        private volatile boolean importInProgress = false;
        private volatile boolean awaitingGlobalCache = false;
        private volatile long lastImportStart = 0L;
        private volatile long lastImportDuration = 0L;
        private volatile long lastUpdated = 0L;

        private PlayerAdvancementState() {
        }
    }
}

