/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync.utils;

import org.bukkit.Bukkit;

public class VersionCompatibility {
    private static String serverVersion;
    private static int majorVersion;
    private static int minorVersion;
    private static int patchVersion;

    private static void parseVersion(String version) {
        try {
            String[] parts = version.split("-")[0].split("\\.");
            majorVersion = Integer.parseInt(parts[0]);
            minorVersion = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            patchVersion = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        }
        catch (Exception e) {
            majorVersion = 0;
            minorVersion = 0;
            patchVersion = 0;
        }
    }

    public static boolean isAtLeast(int major, int minor, int patch) {
        if (majorVersion > major) {
            return true;
        }
        if (majorVersion < major) {
            return false;
        }
        if (minorVersion > minor) {
            return true;
        }
        if (minorVersion < minor) {
            return false;
        }
        return patchVersion >= patch;
    }

    public static boolean isBetween(int majorMin, int minorMin, int patchMin, int majorMax, int minorMax, int patchMax) {
        return VersionCompatibility.isAtLeast(majorMin, minorMin, patchMin) && !VersionCompatibility.isAtLeast(majorMax, minorMax, patchMax + 1);
    }

    public static String getServerVersion() {
        return serverVersion;
    }

    public static boolean isOffhandSupported() {
        return VersionCompatibility.isAtLeast(1, 9, 0);
    }

    public static boolean isAttributesSupported() {
        return VersionCompatibility.isAtLeast(1, 9, 0);
    }

    public static boolean isAdvancementsSupported() {
        return VersionCompatibility.isAtLeast(1, 12, 0);
    }

    public static boolean isNamespacedKeySupported() {
        return VersionCompatibility.isAtLeast(1, 13, 0);
    }

    public static boolean isVersion1_8() {
        return majorVersion == 1 && minorVersion == 8;
    }

    public static boolean isVersion1_9_to_1_11() {
        return majorVersion == 1 && minorVersion >= 9 && minorVersion <= 11;
    }

    public static boolean isVersion1_12() {
        return majorVersion == 1 && minorVersion == 12;
    }

    public static boolean isVersion1_13_to_1_16() {
        return majorVersion == 1 && minorVersion >= 13 && minorVersion <= 16;
    }

    public static boolean isVersion1_17() {
        return majorVersion == 1 && minorVersion == 17;
    }

    public static boolean isVersion1_18_to_1_20() {
        return majorVersion == 1 && minorVersion >= 18 && minorVersion <= 20;
    }

    public static boolean isVersion1_21_Plus() {
        return majorVersion == 1 && minorVersion >= 21;
    }

    public static String getVersionString() {
        return majorVersion + "." + minorVersion + "." + patchVersion;
    }

    static {
        try {
            serverVersion = Bukkit.getServer().getBukkitVersion();
            VersionCompatibility.parseVersion(serverVersion);
        }
        catch (Exception e) {
            serverVersion = "unknown";
            majorVersion = 0;
            minorVersion = 0;
            patchVersion = 0;
        }
    }
}

