/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync.integration;

import com.example.playerdatasync.core.PlayerDataSync;
import com.example.playerdatasync.database.DatabaseManager;
import com.example.playerdatasync.managers.MessageManager;
import com.example.playerdatasync.utils.OfflinePlayerData;
import com.example.playerdatasync.utils.VersionCompatibility;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InventoryViewerIntegrationManager
implements Listener {
    private static final Set<String> INVSEE_COMMANDS = new HashSet<String>(Arrays.asList("invsee", "isee"));
    private static final Set<String> INVSEE_ENDER_COMMANDS = new HashSet<String>(Arrays.asList("endersee", "enderinv"));
    private static final Set<String> OPENINV_COMMANDS = new HashSet<String>(Arrays.asList("openinv", "oi"));
    private static final Set<String> OPENINV_ENDER_COMMANDS = new HashSet<String>(Arrays.asList("openender", "enderchest", "openec", "ec"));
    private final PlayerDataSync plugin;
    private final DatabaseManager databaseManager;
    private final MessageManager messageManager;
    private boolean invSeeEnabled;
    private boolean openInvEnabled;
    private final ItemStack fillerItem;

    public InventoryViewerIntegrationManager(PlayerDataSync plugin, DatabaseManager databaseManager, boolean invSeeEnabled, boolean openInvEnabled) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.messageManager = plugin.getMessageManager();
        this.invSeeEnabled = invSeeEnabled;
        this.openInvEnabled = openInvEnabled;
        this.fillerItem = this.createFillerItem();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.detectExternalPlugins();
    }

    private void detectExternalPlugins() {
        if (this.invSeeEnabled && this.plugin.getServer().getPluginManager().getPlugin("InvSee++") != null) {
            this.plugin.getLogger().info("InvSee++ detected. Routing inventory viewing through PlayerDataSync storage.");
        }
        if (this.openInvEnabled && this.plugin.getServer().getPluginManager().getPlugin("OpenInv") != null) {
            this.plugin.getLogger().info("OpenInv detected. Routing inventory viewing through PlayerDataSync storage.");
        }
    }

    public void updateSettings(boolean invSeeEnabled, boolean openInvEnabled) {
        this.invSeeEnabled = invSeeEnabled;
        this.openInvEnabled = openInvEnabled;
    }

    public void shutdown() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryCommand(PlayerCommandPreprocessEvent event) {
        boolean enderCommand;
        if (!this.invSeeEnabled && !this.openInvEnabled) {
            return;
        }
        String rawMessage = event.getMessage();
        if (rawMessage == null || rawMessage.isEmpty()) {
            return;
        }
        String trimmed = rawMessage.trim();
        if (!trimmed.startsWith("/")) {
            return;
        }
        String[] parts = trimmed.substring(1).split("\\s+");
        if (parts.length == 0) {
            return;
        }
        String baseCommand = parts[0].toLowerCase(Locale.ROOT);
        boolean inventoryCommand = this.invSeeEnabled && INVSEE_COMMANDS.contains(baseCommand) || this.openInvEnabled && OPENINV_COMMANDS.contains(baseCommand);
        boolean bl = enderCommand = this.invSeeEnabled && INVSEE_ENDER_COMMANDS.contains(baseCommand) || this.openInvEnabled && OPENINV_ENDER_COMMANDS.contains(baseCommand);
        if (!inventoryCommand && !enderCommand) {
            return;
        }
        Player player = event.getPlayer();
        if (inventoryCommand && !player.hasPermission("playerdatasync.integration.invsee")) {
            player.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("no_permission"));
            event.setCancelled(true);
            return;
        }
        if (enderCommand && !player.hasPermission("playerdatasync.integration.enderchest")) {
            player.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("no_permission"));
            event.setCancelled(true);
            return;
        }
        if (parts.length < 2) {
            String usageKey = enderCommand ? "inventory_view_usage_ender" : "inventory_view_usage_inventory";
            player.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get(usageKey));
            event.setCancelled(true);
            return;
        }
        String targetName = parts[1];
        event.setCancelled(true);
        this.handleInventoryRequest(player, targetName, enderCommand);
    }

    private void handleInventoryRequest(Player viewer, String targetName, boolean enderChest) {
        Player offline = null;
        try {
            Player onlinePlayer = Bukkit.getPlayer((String)targetName);
            if (onlinePlayer != null) {
                offline = onlinePlayer;
            } else {
                OfflinePlayer tempPlayer = Bukkit.getOfflinePlayer((String)targetName);
                offline = tempPlayer;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not get offline player for " + targetName + ": " + e.getMessage());
            return;
        }
        if (offline == null) {
            return;
        }
        UUID targetUuid = offline != null ? offline.getUniqueId() : null;
        String displayName = offline != null && offline.getName() != null ? offline.getName() : targetName;
        viewer.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("inventory_view_loading").replace("{player}", displayName));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            OfflinePlayerData data;
            try {
                data = this.databaseManager.loadOfflinePlayerData(targetUuid, displayName);
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Failed to load offline data for " + displayName + ": " + ex.getMessage());
                data = null;
            }
            if (data == null) {
                String message = this.messageManager.get("prefix") + " " + this.messageManager.get("inventory_view_open_failed").replace("{player}", displayName);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (viewer.isOnline()) {
                        viewer.sendMessage(message);
                    }
                });
                return;
            }
            OfflinePlayerData finalData = data;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!viewer.isOnline()) {
                    return;
                }
                if (!finalData.existsInDatabase()) {
                    viewer.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("inventory_view_no_data").replace("{player}", finalData.getDisplayName()));
                }
                if (enderChest) {
                    this.openEnderChestInventory(viewer, finalData);
                } else {
                    this.openMainInventory(viewer, finalData);
                }
            });
        });
    }

    private void openMainInventory(Player viewer, OfflinePlayerData data) {
        OfflineInventoryHolder holder = new OfflineInventoryHolder(data, false);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)45, (String)this.messageManager.get("inventory_view_title_inventory").replace("{player}", data.getDisplayName()));
        holder.setInventory(inventory);
        ItemStack[] main = data.getInventoryContents();
        for (int slot = 0; slot < 36; ++slot) {
            inventory.setItem(slot, slot < main.length ? main[slot] : null);
        }
        ItemStack[] armor = data.getArmorContents();
        inventory.setItem(36, armor.length > 3 ? armor[3] : null);
        inventory.setItem(37, armor.length > 2 ? armor[2] : null);
        inventory.setItem(38, armor.length > 1 ? armor[1] : null);
        inventory.setItem(39, armor.length > 0 ? armor[0] : null);
        inventory.setItem(40, data.getOffhandItem());
        for (int slot = 41; slot < 45; ++slot) {
            inventory.setItem(slot, this.fillerItem.clone());
        }
        viewer.openInventory(inventory);
    }

    private void openEnderChestInventory(Player viewer, OfflinePlayerData data) {
        OfflineInventoryHolder holder = new OfflineInventoryHolder(data, true);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)27, (String)this.messageManager.get("inventory_view_title_ender").replace("{player}", data.getDisplayName()));
        holder.setInventory(inventory);
        ItemStack[] contents = data.getEnderChestContents();
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, i < contents.length ? contents[i] : null);
        }
        viewer.openInventory(inventory);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        int topSize;
        int rawSlot;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof OfflineInventoryHolder)) {
            return;
        }
        OfflineInventoryHolder holder = (OfflineInventoryHolder)inventoryHolder;
        if (!holder.isEnderChest() && (rawSlot = event.getRawSlot()) < (topSize = event.getView().getTopInventory().getSize()) && rawSlot >= 41) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof OfflineInventoryHolder)) {
            return;
        }
        OfflineInventoryHolder holder = (OfflineInventoryHolder)inventoryHolder;
        if (holder.isEnderChest()) {
            return;
        }
        int topSize = event.getView().getTopInventory().getSize();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int rawSlot = (Integer)iterator.next();
            if (rawSlot >= topSize || rawSlot < 41) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof OfflineInventoryHolder)) {
            return;
        }
        OfflineInventoryHolder holder = (OfflineInventoryHolder)inventoryHolder;
        Inventory inventory = event.getInventory();
        OfflinePlayerData data = holder.getData();
        UUID viewerId = ((Player)event.getPlayer()).getUniqueId();
        if (holder.isEnderChest()) {
            ItemStack[] contents = Arrays.copyOf(inventory.getContents(), inventory.getSize());
            data.setEnderChestContents(contents);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                boolean success = this.databaseManager.saveOfflineEnderChestData(data);
                if (!success) {
                    this.notifySaveFailure(viewerId, data.getDisplayName());
                }
            });
        } else {
            ItemStack[] main = new ItemStack[36];
            for (int i = 0; i < 36; ++i) {
                main[i] = inventory.getItem(i);
            }
            ItemStack[] armor = new ItemStack[4];
            armor[3] = inventory.getItem(36);
            armor[2] = inventory.getItem(37);
            armor[1] = inventory.getItem(38);
            armor[0] = inventory.getItem(39);
            ItemStack offhand = inventory.getItem(40);
            data.setInventoryContents(main);
            data.setArmorContents(armor);
            data.setOffhandItem(offhand);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                boolean success = this.databaseManager.saveOfflineInventoryData(data);
                if (!success) {
                    this.notifySaveFailure(viewerId, data.getDisplayName());
                }
            });
        }
    }

    private void notifySaveFailure(UUID viewerId, String playerName) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Player viewer = Bukkit.getPlayer((UUID)viewerId);
            if (viewer != null && viewer.isOnline()) {
                viewer.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("inventory_view_save_failed").replace("{player}", playerName));
            }
        });
    }

    private ItemStack createFillerItem() {
        ItemMeta meta;
        Material paneMaterial;
        try {
            paneMaterial = VersionCompatibility.isAtLeast(1, 13, 0) ? Material.GRAY_STAINED_GLASS_PANE : Material.valueOf((String)"STAINED_GLASS_PANE");
        }
        catch (IllegalArgumentException e) {
            paneMaterial = Material.GLASS_PANE;
            this.plugin.getLogger().warning("Could not find STAINED_GLASS_PANE, using GLASS_PANE as fallback");
        }
        ItemStack pane = new ItemStack(paneMaterial);
        if (!VersionCompatibility.isAtLeast(1, 13, 0)) {
            try {
                pane.setDurability((short)7);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not set glass pane color for filler item: " + e.getMessage());
            }
        }
        if ((meta = pane.getItemMeta()) != null) {
            meta.setDisplayName(" ");
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            pane.setItemMeta(meta);
        }
        return pane;
    }

    private static final class OfflineInventoryHolder
    implements InventoryHolder {
        private final OfflinePlayerData data;
        private final boolean enderChest;
        private Inventory inventory;

        private OfflineInventoryHolder(OfflinePlayerData data, boolean enderChest) {
            this.data = data;
            this.enderChest = enderChest;
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        private void setInventory(Inventory inventory) {
            this.inventory = inventory;
        }

        private OfflinePlayerData getData() {
            return this.data;
        }

        private boolean isEnderChest() {
            return this.enderChest;
        }
    }
}

