/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync.core;

import com.example.playerdatasync.api.UpdateChecker;
import com.example.playerdatasync.commands.SyncCommand;
import com.example.playerdatasync.database.ConnectionPool;
import com.example.playerdatasync.database.DatabaseManager;
import com.example.playerdatasync.integration.EditorIntegrationManager;
import com.example.playerdatasync.integration.InventoryViewerIntegrationManager;
import com.example.playerdatasync.libs.bstats.bukkit.Metrics;
import com.example.playerdatasync.listeners.PlayerDataListener;
import com.example.playerdatasync.listeners.ServerSwitchListener;
import com.example.playerdatasync.managers.AdvancementSyncManager;
import com.example.playerdatasync.managers.BackupManager;
import com.example.playerdatasync.managers.ConfigManager;
import com.example.playerdatasync.managers.MessageManager;
import com.example.playerdatasync.utils.VersionCompatibility;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class PlayerDataSync
extends JavaPlugin {
    private Connection connection;
    private ConnectionPool connectionPool;
    private String databaseType;
    private String databaseUrl;
    private String databaseUser;
    private String databasePassword;
    private String tablePrefix;
    private boolean syncCoordinates;
    private boolean syncXp;
    private boolean syncGamemode;
    private boolean syncEnderchest;
    private boolean syncInventory;
    private boolean syncHealth;
    private boolean syncHunger;
    private boolean syncPosition;
    private boolean syncAchievements;
    private boolean syncArmor;
    private boolean syncOffhand;
    private boolean syncEffects;
    private boolean syncStatistics;
    private boolean syncAttributes;
    private boolean syncPermissions;
    private boolean syncEconomy;
    private Economy economyProvider;
    private boolean bungeecordIntegrationEnabled;
    private DatabaseManager databaseManager;
    private AdvancementSyncManager advancementSyncManager;
    private ConfigManager configManager;
    private BackupManager backupManager;
    private EditorIntegrationManager editorIntegrationManager;
    private InventoryViewerIntegrationManager inventoryViewerIntegrationManager;
    private int autosaveIntervalSeconds;
    private BukkitTask autosaveTask;
    private MessageManager messageManager;
    private Metrics metrics;

    public void onEnable() {
        block25: {
            this.getLogger().info("Enabling PlayerDataSync...");
            this.checkVersionCompatibility();
            this.getLogger().info("Saving default configuration...");
            this.saveDefaultConfig();
            File configFile = new File(this.getDataFolder(), "config.yml");
            if (configFile.exists()) {
                this.getLogger().info("Config file exists. Size: " + configFile.length() + " bytes");
                if (configFile.length() == 0L) {
                    this.getLogger().warning("Config file is empty (0 bytes)! This indicates a problem with the JAR file or resource loading.");
                }
            } else {
                this.getLogger().warning("Config file does not exist after saveDefaultConfig()!");
                this.getLogger().warning("This usually means the config.yml resource is not properly embedded in the JAR file.");
            }
            if (this.getConfig().getKeys(false).isEmpty()) {
                this.getLogger().warning("Configuration file is empty! Recreating from defaults...");
                this.reloadConfig();
                this.saveDefaultConfig();
                if (this.getConfig().getKeys(false).isEmpty()) {
                    this.getLogger().severe("CRITICAL: Failed to load configuration! Plugin will be disabled.");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
            this.configManager = new ConfigManager(this);
            this.tablePrefix = this.configManager.getTablePrefix();
            Level configuredLevel = this.configManager.getLoggingLevel();
            if (this.configManager.isDebugMode() && configuredLevel.intValue() > Level.FINE.intValue()) {
                configuredLevel = Level.FINE;
            }
            this.getLogger().setLevel(configuredLevel);
            if (this.getConfig().getKeys(false).isEmpty()) {
                this.getLogger().warning("Configuration still empty after ConfigManager init. Force initializing defaults...");
                this.configManager.initializeDefaultConfig();
                this.reloadConfig();
                if (this.getConfig().getKeys(false).isEmpty()) {
                    this.getLogger().severe("CRITICAL: All configuration loading methods failed!");
                    this.getLogger().severe("Creating emergency minimal configuration...");
                    this.createEmergencyConfig();
                    this.reloadConfig();
                }
            }
            this.messageManager = new MessageManager(this);
            String lang = this.getConfig().getString("messages.language", "en");
            try {
                this.messageManager.load(lang);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load messages for language " + lang + ", falling back to English");
                try {
                    this.messageManager.load("en");
                }
                catch (Exception e2) {
                    this.getLogger().severe("Failed to load any message files: " + e2.getMessage());
                }
            }
            if (this.getConfig().getBoolean("metrics", true)) {
                if (this.metrics == null) {
                    this.metrics = new Metrics(this, 25037);
                }
            } else {
                this.metrics = null;
            }
            this.editorIntegrationManager = new EditorIntegrationManager(this);
            this.editorIntegrationManager.start();
            this.databaseType = this.getConfig().getString("database.type", "mysql");
            try {
                if (this.databaseType.equalsIgnoreCase("mysql")) {
                    String host = this.getConfig().getString("database.mysql.host", "localhost");
                    int port = this.getConfig().getInt("database.mysql.port", 3306);
                    String database = this.getConfig().getString("database.mysql.database", "minecraft");
                    this.databaseUser = this.getConfig().getString("database.mysql.user", "root");
                    this.databasePassword = this.getConfig().getString("database.mysql.password", "");
                    this.databaseUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=%s&autoReconnect=true&failOverReadOnly=false&maxReconnects=3", host, port, database, this.getConfig().getBoolean("database.mysql.ssl", false));
                    this.connection = DriverManager.getConnection(this.databaseUrl, this.databaseUser, this.databasePassword);
                    this.getLogger().info("Connected to MySQL database at " + host + ":" + port + "/" + database);
                    if (this.getConfig().getBoolean("performance.connection_pooling", true)) {
                        int maxConnections = this.getConfig().getInt("database.mysql.max_connections", 10);
                        this.connectionPool = new ConnectionPool(this, this.databaseUrl, this.databaseUser, this.databasePassword, maxConnections);
                        this.connectionPool.initialize();
                    }
                    break block25;
                }
                if (this.databaseType.equalsIgnoreCase("sqlite")) {
                    String file = this.getConfig().getString("database.sqlite.file", "plugins/PlayerDataSync/playerdata.db");
                    File dbFile = new File(file);
                    if (!dbFile.getParentFile().exists()) {
                        dbFile.getParentFile().mkdirs();
                    }
                    this.databaseUrl = "jdbc:sqlite:" + file;
                    this.databaseUser = null;
                    this.databasePassword = null;
                    this.connection = DriverManager.getConnection(this.databaseUrl);
                    this.getLogger().info("Connected to SQLite database at " + file);
                    break block25;
                }
                this.getLogger().severe("Unsupported database type: " + this.databaseType + ". Supported types: mysql, sqlite");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            catch (SQLException e) {
                this.getLogger().severe("Could not connect to " + this.databaseType + " database: " + e.getMessage());
                this.getLogger().severe("Please check your database configuration and ensure the database server is running");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        this.loadSyncSettings();
        this.advancementSyncManager = new AdvancementSyncManager(this);
        this.bungeecordIntegrationEnabled = this.getConfig().getBoolean("integrations.bungeecord", false);
        if (this.bungeecordIntegrationEnabled) {
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.getLogger().info("BungeeCord integration enabled. Plugin messaging channel registered.");
        }
        this.autosaveIntervalSeconds = this.getConfig().getInt("autosave.interval", 1);
        if (this.autosaveIntervalSeconds > 0) {
            long ticks = (long)this.autosaveIntervalSeconds * 20L;
            this.autosaveTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    int savedCount = 0;
                    long startTime = System.currentTimeMillis();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        try {
                            if (this.databaseManager.savePlayer(player)) {
                                ++savedCount;
                                continue;
                            }
                            this.getLogger().warning("Failed to autosave data for " + player.getName() + ": See previous log entries for details.");
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Failed to autosave data for " + player.getName() + ": " + e.getMessage());
                        }
                    }
                    long endTime = System.currentTimeMillis();
                    if (savedCount > 0 && this.isPerformanceLoggingEnabled()) {
                        this.getLogger().info("Autosaved data for " + savedCount + " players in " + (endTime - startTime) + "ms");
                    }
                }
                catch (Exception e) {
                    this.getLogger().severe("Error during autosave: " + e.getMessage());
                }
            }, ticks, ticks);
            this.getLogger().info("Autosave task scheduled with interval: " + this.autosaveIntervalSeconds + " seconds");
        }
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        boolean invSeeIntegration = this.getConfig().getBoolean("integrations.invsee", true);
        boolean openInvIntegration = this.getConfig().getBoolean("integrations.openinv", true);
        if (invSeeIntegration || openInvIntegration) {
            this.inventoryViewerIntegrationManager = new InventoryViewerIntegrationManager(this, this.databaseManager, invSeeIntegration, openInvIntegration);
        }
        this.configureEconomyIntegration();
        this.backupManager = new BackupManager(this);
        this.backupManager.startAutomaticBackups();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDataListener(this, this.databaseManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ServerSwitchListener(this, this.databaseManager), (Plugin)this);
        if (this.getCommand("sync") != null) {
            SyncCommand syncCommand = new SyncCommand(this);
            this.getCommand("sync").setExecutor((CommandExecutor)syncCommand);
            this.getCommand("sync").setTabCompleter((TabCompleter)syncCommand);
        }
        new UpdateChecker(this, this.messageManager).check();
        this.getLogger().info("PlayerDataSync enabled successfully!");
    }

    public void onDisable() {
        this.getLogger().info("Disabling PlayerDataSync...");
        if (this.autosaveTask != null) {
            this.autosaveTask.cancel();
            this.autosaveTask = null;
            this.getLogger().info("Autosave task cancelled");
        }
        if (this.bungeecordIntegrationEnabled) {
            this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        }
        if (this.databaseManager != null) {
            try {
                int savedCount = 0;
                long startTime = System.currentTimeMillis();
                if (this.syncEconomy) {
                    this.getLogger().info("Reconfiguring economy integration for shutdown save...");
                    this.configureEconomyIntegration();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    try {
                        if (this.syncEconomy && this.economyProvider != null) {
                            try {
                                double currentBalance = this.economyProvider.getBalance((OfflinePlayer)player);
                                this.getLogger().fine("Current balance for " + player.getName() + " before shutdown save: " + currentBalance);
                            }
                            catch (Exception e) {
                                this.getLogger().warning("Could not read balance for " + player.getName() + " before shutdown: " + e.getMessage());
                            }
                        }
                        if (this.databaseManager.savePlayer(player)) {
                            ++savedCount;
                            this.getLogger().fine("Saved data for " + player.getName() + " during shutdown");
                            continue;
                        }
                        this.getLogger().severe("Failed to save data for " + player.getName() + " during shutdown: See previous log entries for details.");
                    }
                    catch (Exception e) {
                        this.getLogger().severe("Failed to save data for " + player.getName() + " during shutdown: " + e.getMessage());
                        this.getLogger().log(Level.SEVERE, "Stack trace:", e);
                    }
                }
                long endTime = System.currentTimeMillis();
                if (savedCount > 0) {
                    this.getLogger().info("Saved data for " + savedCount + " players during shutdown in " + (endTime - startTime) + "ms (including economy balances)");
                } else {
                    this.getLogger().warning("No players were saved during shutdown - this may cause data loss!");
                }
            }
            catch (Exception e) {
                this.getLogger().severe("Error saving players during shutdown: " + e.getMessage());
                this.getLogger().log(Level.SEVERE, "Stack trace:", e);
            }
        }
        if (this.backupManager != null) {
            this.backupManager.stopAutomaticBackups();
            this.backupManager = null;
        }
        if (this.editorIntegrationManager != null) {
            this.editorIntegrationManager.shutdown();
            this.editorIntegrationManager = null;
        }
        if (this.advancementSyncManager != null) {
            this.advancementSyncManager.shutdown();
            this.advancementSyncManager = null;
        }
        if (this.inventoryViewerIntegrationManager != null) {
            this.inventoryViewerIntegrationManager.shutdown();
            this.inventoryViewerIntegrationManager = null;
        }
        if (this.connectionPool != null) {
            this.connectionPool.shutdown();
            this.connectionPool = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                if (this.databaseType.equalsIgnoreCase("mysql")) {
                    this.getLogger().info("MySQL connection closed");
                } else {
                    this.getLogger().info("SQLite connection closed");
                }
            }
            catch (SQLException e) {
                this.getLogger().severe("Error closing database connection: " + e.getMessage());
            }
        }
        this.getLogger().info("PlayerDataSync disabled successfully");
    }

    private Connection createConnection() throws SQLException {
        if (this.databaseType.equalsIgnoreCase("mysql")) {
            return DriverManager.getConnection(this.databaseUrl, this.databaseUser, this.databasePassword);
        }
        return DriverManager.getConnection(this.databaseUrl);
    }

    public synchronized Connection getConnection() {
        try {
            if (this.connectionPool != null) {
                return this.connectionPool.getConnection();
            }
            if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(2)) {
                this.connection = this.createConnection();
                this.getLogger().info("Reconnected to database");
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("Could not establish database connection: " + e.getMessage());
        }
        return this.connection;
    }

    public void returnConnection(Connection conn) {
        if (this.connectionPool != null && conn != null) {
            this.connectionPool.returnConnection(conn);
        }
    }

    public boolean isSyncCoordinates() {
        return this.syncCoordinates;
    }

    public boolean isSyncXp() {
        return this.syncXp;
    }

    public boolean isSyncGamemode() {
        return this.syncGamemode;
    }

    public boolean isSyncEnderchest() {
        return this.syncEnderchest;
    }

    public boolean isSyncInventory() {
        return this.syncInventory;
    }

    public boolean isSyncHealth() {
        return this.syncHealth;
    }

    public boolean isSyncHunger() {
        return this.syncHunger;
    }

    public boolean isSyncPosition() {
        return this.syncPosition;
    }

    public boolean isSyncAchievements() {
        return this.syncAchievements;
    }

    public void setSyncCoordinates(boolean value) {
        this.syncCoordinates = value;
        this.getConfig().set("sync.coordinates", (Object)value);
        this.saveConfig();
    }

    public void setSyncXp(boolean value) {
        this.syncXp = value;
        this.getConfig().set("sync.xp", (Object)value);
        this.saveConfig();
    }

    public void setSyncGamemode(boolean value) {
        this.syncGamemode = value;
        this.getConfig().set("sync.gamemode", (Object)value);
        this.saveConfig();
    }

    public void setSyncEnderchest(boolean value) {
        this.syncEnderchest = value;
        this.getConfig().set("sync.enderchest", (Object)value);
        this.saveConfig();
    }

    public void setSyncInventory(boolean value) {
        this.syncInventory = value;
        this.getConfig().set("sync.inventory", (Object)value);
        this.saveConfig();
    }

    public void setSyncHealth(boolean value) {
        this.syncHealth = value;
        this.getConfig().set("sync.health", (Object)value);
        this.saveConfig();
    }

    public void setSyncHunger(boolean value) {
        this.syncHunger = value;
        this.getConfig().set("sync.hunger", (Object)value);
        this.saveConfig();
    }

    public void setSyncPosition(boolean value) {
        this.syncPosition = value;
        this.getConfig().set("sync.position", (Object)value);
        this.saveConfig();
    }

    public void setSyncAchievements(boolean value) {
        this.syncAchievements = value;
        this.getConfig().set("sync.achievements", (Object)value);
        this.saveConfig();
    }

    private void loadSyncSettings() {
        this.syncCoordinates = this.getConfig().getBoolean("sync.coordinates", true);
        this.syncXp = this.getConfig().getBoolean("sync.xp", true);
        this.syncGamemode = this.getConfig().getBoolean("sync.gamemode", true);
        this.syncEnderchest = this.getConfig().getBoolean("sync.enderchest", true);
        this.syncInventory = this.getConfig().getBoolean("sync.inventory", true);
        this.syncHealth = this.getConfig().getBoolean("sync.health", true);
        this.syncHunger = this.getConfig().getBoolean("sync.hunger", true);
        this.syncPosition = this.getConfig().getBoolean("sync.position", true);
        this.syncArmor = this.getConfig().getBoolean("sync.armor", true);
        boolean bl = this.syncOffhand = VersionCompatibility.isOffhandSupported() && this.getConfig().getBoolean("sync.offhand", true);
        if (!VersionCompatibility.isOffhandSupported() && this.getConfig().getBoolean("sync.offhand", true)) {
            this.getLogger().info("Offhand sync disabled - requires Minecraft 1.9+");
            this.getConfig().set("sync.offhand", (Object)false);
        }
        this.syncEffects = this.getConfig().getBoolean("sync.effects", true);
        this.syncStatistics = this.getConfig().getBoolean("sync.statistics", true);
        boolean bl2 = this.syncAttributes = VersionCompatibility.isAttributesSupported() && this.getConfig().getBoolean("sync.attributes", true);
        if (!VersionCompatibility.isAttributesSupported() && this.getConfig().getBoolean("sync.attributes", true)) {
            this.getLogger().info("Attribute sync disabled - requires Minecraft 1.9+");
            this.getConfig().set("sync.attributes", (Object)false);
        }
        boolean bl3 = this.syncAchievements = VersionCompatibility.isAdvancementsSupported() && this.getConfig().getBoolean("sync.achievements", true);
        if (!VersionCompatibility.isAdvancementsSupported() && this.getConfig().getBoolean("sync.achievements", true)) {
            this.getLogger().info("Advancement sync disabled - requires Minecraft 1.12+");
            this.getConfig().set("sync.achievements", (Object)false);
        }
        this.syncPermissions = this.getConfig().getBoolean("sync.permissions", false);
        this.syncEconomy = this.getConfig().getBoolean("sync.economy", false);
        this.saveConfig();
    }

    public void reloadPlugin() {
        int newIntervalSeconds;
        this.reloadConfig();
        if (this.configManager != null) {
            this.configManager.reloadConfig();
            this.tablePrefix = this.configManager.getTablePrefix();
        }
        String lang = this.getConfig().getString("messages.language", "en");
        this.messageManager.load(lang);
        if (this.getConfig().getBoolean("metrics", true)) {
            if (this.metrics == null) {
                this.metrics = new Metrics(this, 25037);
            }
        } else {
            this.metrics = null;
        }
        boolean wasBungeeEnabled = this.bungeecordIntegrationEnabled;
        this.bungeecordIntegrationEnabled = this.getConfig().getBoolean("integrations.bungeecord", false);
        if (this.bungeecordIntegrationEnabled && !wasBungeeEnabled) {
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.getLogger().info("BungeeCord integration enabled after reload. Plugin messaging channel registered.");
        } else if (!this.bungeecordIntegrationEnabled && wasBungeeEnabled) {
            this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
            this.getLogger().info("BungeeCord integration disabled after reload. Plugin messaging channel unregistered.");
        }
        this.loadSyncSettings();
        boolean invSeeIntegration = this.getConfig().getBoolean("integrations.invsee", true);
        boolean openInvIntegration = this.getConfig().getBoolean("integrations.openinv", true);
        if (this.inventoryViewerIntegrationManager != null) {
            if (!invSeeIntegration && !openInvIntegration) {
                this.inventoryViewerIntegrationManager.shutdown();
                this.inventoryViewerIntegrationManager = null;
            } else {
                this.inventoryViewerIntegrationManager.updateSettings(invSeeIntegration, openInvIntegration);
            }
        } else if (invSeeIntegration || openInvIntegration) {
            this.inventoryViewerIntegrationManager = new InventoryViewerIntegrationManager(this, this.databaseManager, invSeeIntegration, openInvIntegration);
        }
        if (this.advancementSyncManager != null) {
            this.advancementSyncManager.reloadFromConfig();
        }
        if ((newIntervalSeconds = this.getConfig().getInt("autosave.interval", 1)) != this.autosaveIntervalSeconds) {
            this.autosaveIntervalSeconds = newIntervalSeconds;
            if (this.autosaveTask != null) {
                this.autosaveTask.cancel();
                this.autosaveTask = null;
            }
            if (this.autosaveIntervalSeconds > 0) {
                long ticks = (long)this.autosaveIntervalSeconds * 20L;
                this.autosaveTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                    try {
                        int savedCount = 0;
                        long startTime = System.currentTimeMillis();
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            try {
                                if (this.databaseManager.savePlayer(player)) {
                                    ++savedCount;
                                    continue;
                                }
                                this.getLogger().warning("Failed to autosave data for " + player.getName() + ": See previous log entries for details.");
                            }
                            catch (Exception e) {
                                this.getLogger().warning("Failed to autosave data for " + player.getName() + ": " + e.getMessage());
                            }
                        }
                        long endTime = System.currentTimeMillis();
                        if (savedCount > 0 && this.isPerformanceLoggingEnabled()) {
                            this.getLogger().info("Autosaved data for " + savedCount + " players in " + (endTime - startTime) + "ms");
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().severe("Error during autosave: " + e.getMessage());
                    }
                }, ticks, ticks);
                this.getLogger().info("Autosave task restarted with interval: " + this.autosaveIntervalSeconds + " seconds");
            }
        }
    }

    public boolean isSyncArmor() {
        return this.syncArmor;
    }

    public boolean isSyncOffhand() {
        return this.syncOffhand;
    }

    public boolean isSyncEffects() {
        return this.syncEffects;
    }

    public boolean isSyncStatistics() {
        return this.syncStatistics;
    }

    public boolean isSyncAttributes() {
        return this.syncAttributes;
    }

    public boolean isSyncPermissions() {
        return this.syncPermissions;
    }

    public boolean isSyncEconomy() {
        return this.syncEconomy;
    }

    public void setSyncArmor(boolean value) {
        this.syncArmor = value;
        this.getConfig().set("sync.armor", (Object)value);
        this.saveConfig();
    }

    public void setSyncOffhand(boolean value) {
        this.syncOffhand = value;
        this.getConfig().set("sync.offhand", (Object)value);
        this.saveConfig();
    }

    public void setSyncEffects(boolean value) {
        this.syncEffects = value;
        this.getConfig().set("sync.effects", (Object)value);
        this.saveConfig();
    }

    public void setSyncStatistics(boolean value) {
        this.syncStatistics = value;
        this.getConfig().set("sync.statistics", (Object)value);
        this.saveConfig();
    }

    public void setSyncAttributes(boolean value) {
        this.syncAttributes = value;
        this.getConfig().set("sync.attributes", (Object)value);
        this.saveConfig();
    }

    public void setSyncPermissions(boolean value) {
        this.syncPermissions = value;
        this.getConfig().set("sync.permissions", (Object)value);
        this.saveConfig();
    }

    public void setSyncEconomy(boolean value) {
        this.syncEconomy = value;
        this.getConfig().set("sync.economy", (Object)value);
        this.configureEconomyIntegration();
        this.saveConfig();
    }

    public void triggerEconomySync(Player player) {
        if (!this.syncEconomy) {
            this.logDebug("Economy sync disabled, skipping manual trigger for " + player.getName());
            return;
        }
        this.logDebug("Manual economy sync triggered for " + player.getName());
        try {
            long startTime = System.currentTimeMillis();
            this.databaseManager.savePlayer(player);
            long endTime = System.currentTimeMillis();
            this.logDebug("Manual economy sync completed for " + player.getName() + " in " + (endTime - startTime) + "ms");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to manually sync economy for " + player.getName() + ": " + e.getMessage());
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public String getTablePrefix() {
        return this.tablePrefix != null ? this.tablePrefix : "player_data";
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public AdvancementSyncManager getAdvancementSyncManager() {
        return this.advancementSyncManager;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public EditorIntegrationManager getEditorIntegrationManager() {
        return this.editorIntegrationManager;
    }

    public Economy getEconomyProvider() {
        return this.economyProvider;
    }

    public boolean isBungeecordIntegrationEnabled() {
        return this.bungeecordIntegrationEnabled;
    }

    public void syncPlayerEconomy(Player player) {
        this.triggerEconomySync(player);
    }

    public void connectPlayerToServer(Player player, String targetServer) {
        if (!this.bungeecordIntegrationEnabled) {
            this.getLogger().warning("Attempted to send player " + player.getName() + " to server '" + targetServer + "' while BungeeCord integration is disabled.");
            return;
        }
        if (player == null || targetServer == null || targetServer.trim().isEmpty()) {
            this.getLogger().warning("Invalid target server specified for player transfer.");
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            if (!player.isOnline()) {
                return;
            }
            try {
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF("Connect");
                out.writeUTF(targetServer);
                player.sendPluginMessage((Plugin)this, "BungeeCord", out.toByteArray());
                this.getLogger().info("Sent player " + player.getName() + " to server '" + targetServer + "'.");
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to send player " + player.getName() + " to server '" + targetServer + "': " + e.getMessage());
            }
        });
    }

    private void checkVersionCompatibility() {
        if (!this.getConfig().getBoolean("compatibility.version_check", true)) {
            this.getLogger().info("Version compatibility checking is disabled in config");
            return;
        }
        try {
            String serverVersion = Bukkit.getServer().getBukkitVersion();
            String pluginApiVersion = this.getDescription().getAPIVersion();
            this.getLogger().info("Server version: " + serverVersion);
            this.getLogger().info("Plugin API version: " + pluginApiVersion);
            boolean isSupportedVersion = false;
            String versionInfo = "";
            if (VersionCompatibility.isVersion1_8()) {
                isSupportedVersion = true;
                versionInfo = "Minecraft 1.8 - Full compatibility confirmed";
            } else if (VersionCompatibility.isVersion1_9_to_1_11()) {
                isSupportedVersion = true;
                versionInfo = "Minecraft 1.9-1.11 - Full compatibility confirmed";
            } else if (VersionCompatibility.isVersion1_12()) {
                isSupportedVersion = true;
                versionInfo = "Minecraft 1.12 - Full compatibility confirmed";
            } else if (VersionCompatibility.isVersion1_13_to_1_16()) {
                isSupportedVersion = true;
                versionInfo = "Minecraft 1.13-1.16 - Full compatibility confirmed";
            } else if (VersionCompatibility.isVersion1_17()) {
                isSupportedVersion = true;
                versionInfo = "Minecraft 1.17 - Full compatibility confirmed";
            } else if (VersionCompatibility.isVersion1_18_to_1_20()) {
                isSupportedVersion = true;
                versionInfo = "Minecraft 1.18-1.20 - Full compatibility confirmed";
            } else if (VersionCompatibility.isVersion1_21_Plus()) {
                isSupportedVersion = true;
                versionInfo = "Minecraft 1.21+ - Full compatibility confirmed";
            }
            if (isSupportedVersion) {
                this.getLogger().info("\u2705 " + versionInfo);
            } else {
                this.getLogger().warning("================================================");
                this.getLogger().warning("VERSION COMPATIBILITY WARNING:");
                this.getLogger().warning("This plugin supports Minecraft 1.8 to 1.21.11");
                this.getLogger().warning("Current server version: " + serverVersion);
                this.getLogger().warning("Some features may not work correctly");
                this.getLogger().warning("Consider updating to a supported version");
                this.getLogger().warning("================================================");
            }
            if (VersionCompatibility.isAttributesSupported()) {
                try {
                    Attribute.values();
                    this.getLogger().info("Attribute API compatibility: OK");
                }
                catch (Exception e) {
                    this.getLogger().severe("CRITICAL: Attribute API compatibility issue detected!");
                    this.getLogger().severe("This may cause crashes when saving player data");
                    this.getLogger().severe("Error: " + e.getMessage());
                    this.getLogger().warning("Consider setting 'compatibility.safe_attribute_sync: true' in config.yml");
                }
            } else {
                this.getLogger().info("Attribute API not available (requires 1.9+) - attribute sync will be disabled");
            }
            if (!VersionCompatibility.isOffhandSupported()) {
                this.getLogger().info("\u2139\ufe0f  Offhand sync disabled (requires 1.9+)");
            }
            if (!VersionCompatibility.isAdvancementsSupported()) {
                this.getLogger().info("\u2139\ufe0f  Advancements sync disabled (requires 1.12+)");
            }
            this.getLogger().info("\u2705 Running on Minecraft " + VersionCompatibility.getVersionString() + " - Full compatibility confirmed");
        }
        catch (Exception e) {
            this.getLogger().warning("Could not perform version compatibility check: " + e.getMessage());
        }
    }

    private void configureEconomyIntegration() {
        this.logDebug("Economy sync setting from config: " + this.getConfig().getBoolean("sync.economy", false));
        this.logDebug("Economy sync variable: " + this.syncEconomy);
        if (!this.syncEconomy) {
            this.economyProvider = null;
            this.logDebug("Economy sync is disabled in configuration");
            return;
        }
        if (this.setupEconomyIntegration()) {
            this.getLogger().info("Vault integration enabled for economy sync.");
        } else {
            this.economyProvider = null;
            this.syncEconomy = false;
            this.getConfig().set("sync.economy", (Object)false);
            this.saveConfig();
            this.getLogger().warning("Economy sync has been disabled because Vault or an economy provider is unavailable.");
        }
    }

    private boolean setupEconomyIntegration() {
        this.economyProvider = null;
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault plugin not found! Economy sync requires Vault.");
            return false;
        }
        RegisteredServiceProvider registration = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null) {
            this.getLogger().warning("No Vault economy provider registration found. Economy sync requires an economy plugin.");
            return false;
        }
        Economy provider = (Economy)registration.getProvider();
        if (provider == null) {
            this.getLogger().warning("Vault returned a null economy provider. Economy sync cannot continue.");
            return false;
        }
        this.economyProvider = provider;
        this.getLogger().info("Hooked into Vault economy provider: " + provider.getName());
        return true;
    }

    private void createEmergencyConfig() {
        try {
            File configFile = new File(this.getDataFolder(), "config.yml");
            if (!configFile.getParentFile().exists()) {
                configFile.getParentFile().mkdirs();
            }
            String emergencyConfig = "config-version: 3\nserver:\n  id: default\ndatabase:\n  type: sqlite\n  table_prefix: player_data\n  sqlite:\n    file: plugins/PlayerDataSync/playerdata.db\nsync:\n  coordinates: true\n  position: true\n  xp: true\n  gamemode: true\n  inventory: true\n  enderchest: true\n  armor: true\n  offhand: true\n  health: true\n  hunger: true\n  effects: true\n  achievements: true\n  statistics: true\n  attributes: true\n  permissions: false\n  economy: false\nautosave:\n  enabled: true\n  interval: 1\n  on_world_change: true\n  on_death: true\n  async: true\nperformance:\n  batch_size: 50\n  cache_size: 100\n  cache_ttl: 300000\n  cache_compression: true\n  connection_pooling: true\n  async_loading: true\n  disable_achievement_sync_on_large_amounts: true\n  achievement_batch_size: 50\n  achievement_timeout_ms: 5000\n  max_achievements_per_player: 2000\ncompatibility:\n  safe_attribute_sync: true\n  disable_attributes_on_error: false\n  version_check: true\n  legacy_1_20_support: true\n  modern_1_21_support: true\n  disable_achievements_on_critical_error: true\nsecurity:\n  encrypt_data: false\n  hash_uuids: false\n  audit_log: true\nlogging:\n  level: INFO\n  log_database: false\n  log_performance: false\n  debug_mode: false\nupdate_checker:\n  enabled: true\n  notify_ops: true\n  auto_download: false\n  timeout: 10000\nmetrics:\n  bstats: true\n  custom_metrics: true\nmessages:\n  enabled: true\n  language: en\n  prefix: \"&8[&bPDS&8]\"\n  colors: true\n";
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(emergencyConfig);
            }
            this.getLogger().info("Emergency configuration created successfully!");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to create emergency configuration: " + e.getMessage());
            this.getLogger().log(Level.SEVERE, "Stack trace:", e);
        }
    }

    public void logDebug(String message) {
        if (this.configManager != null && this.configManager.isDebugMode()) {
            this.getLogger().log(Level.FINE, message);
        }
    }

    public boolean isDebugEnabled() {
        return this.configManager != null && this.configManager.isDebugMode();
    }

    public boolean isPerformanceLoggingEnabled() {
        return this.configManager != null && this.configManager.isPerformanceLoggingEnabled();
    }
}

