/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync.commands;

import com.example.playerdatasync.core.PlayerDataSync;
import com.example.playerdatasync.integration.EditorIntegrationManager;
import com.example.playerdatasync.managers.AdvancementSyncManager;
import com.example.playerdatasync.managers.BackupManager;
import com.example.playerdatasync.managers.MessageManager;
import com.example.playerdatasync.utils.VersionCompatibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SyncCommand
implements CommandExecutor,
TabCompleter {
    private final PlayerDataSync plugin;
    private final MessageManager messageManager;
    private static final List<String> SYNC_OPTIONS = Arrays.asList("coordinates", "position", "xp", "gamemode", "inventory", "enderchest", "armor", "offhand", "health", "hunger", "effects", "achievements", "statistics", "attributes", "permissions", "economy");
    private static final List<String> SUB_COMMANDS = Arrays.asList("reload", "status", "save", "help", "cache", "validate", "backup", "restore", "achievements", "editor");

    public SyncCommand(PlayerDataSync plugin) {
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return this.showStatus(sender);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "status": {
                return this.handleStatus(sender, args);
            }
            case "save": {
                return this.handleSave(sender, args);
            }
            case "help": {
                return this.showHelp(sender);
            }
            case "cache": {
                return this.handleCache(sender, args);
            }
            case "validate": {
                return this.handleValidate(sender, args);
            }
            case "backup": {
                return this.handleBackup(sender, args);
            }
            case "restore": {
                return this.handleRestore(sender, args);
            }
            case "achievements": {
                return this.handleAchievements(sender, args);
            }
            case "editor": {
                return this.handleEditor(sender, args);
            }
        }
        if (args.length == 2) {
            return this.handleSyncOption(sender, args[0], args[1]);
        }
        return this.showHelp(sender);
    }

    private boolean showStatus(CommandSender sender) {
        if (!this.hasPermission(sender, "playerdatasync.admin")) {
            return true;
        }
        sender.sendMessage(this.messageManager.get("status_header"));
        sender.sendMessage(this.messageManager.get("status_version").replace("{version}", this.plugin.getDescription().getVersion()));
        for (String option : SYNC_OPTIONS) {
            boolean enabled = this.getSyncOptionValue(option);
            String status = enabled ? this.messageManager.get("sync_status_enabled") : this.messageManager.get("sync_status_disabled");
            sender.sendMessage(this.messageManager.get("sync_status").replace("{option}", option).replace("{status}", status));
        }
        sender.sendMessage(this.messageManager.get("status_footer"));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!this.hasPermission(sender, "playerdatasync.admin.reload")) {
            return true;
        }
        try {
            this.plugin.reloadPlugin();
            sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("reloaded"));
        }
        catch (Exception e) {
            sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("reload_failed").replace("{error}", e.getMessage()));
        }
        return true;
    }

    private boolean handleStatus(CommandSender sender, String[] args) {
        Player target;
        if (!this.hasPermission(sender, "playerdatasync.status")) {
            return true;
        }
        if (args.length > 1) {
            if (!this.hasPermission(sender, "playerdatasync.status.others")) {
                return true;
            }
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("player_not_found").replace("{player}", args[1]));
                return true;
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("error_player_offline"));
                return true;
            }
            target = (Player)sender;
        }
        this.showPlayerStatus(sender, target);
        return true;
    }

    private boolean handleSave(CommandSender sender, String[] args) {
        block10: {
            if (!this.hasPermission(sender, "playerdatasync.admin.save")) {
                return true;
            }
            if (args.length > 1) {
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("player_not_found").replace("{player}", args[1]));
                    return true;
                }
                try {
                    if (this.plugin.getDatabaseManager().savePlayer(target)) {
                        sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("manual_save_success"));
                        break block10;
                    }
                    sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("manual_save_failed").replace("{error}", "Unable to persist player data. See console for details."));
                }
                catch (Exception e) {
                    sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("manual_save_failed").replace("{error}", e.getMessage()));
                }
            } else {
                try {
                    int savedCount = 0;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!this.plugin.getDatabaseManager().savePlayer(player)) continue;
                        ++savedCount;
                    }
                    sender.sendMessage(this.messageManager.get("prefix") + " Saved data for " + savedCount + " players.");
                }
                catch (Exception e) {
                    sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("manual_save_failed").replace("{error}", e.getMessage()));
                }
            }
        }
        return true;
    }

    private boolean handleCache(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "playerdatasync.admin")) {
            return true;
        }
        if (args.length > 1 && args[1].equalsIgnoreCase("clear")) {
            this.plugin.getDatabaseManager().resetPerformanceStats();
            sender.sendMessage(this.messageManager.get("prefix") + " Performance statistics cleared.");
        } else {
            String stats = this.plugin.getDatabaseManager().getPerformanceStats();
            sender.sendMessage(this.messageManager.get("prefix") + " Performance Stats: " + stats);
            if (this.plugin.getConnectionPool() != null) {
                sender.sendMessage(this.messageManager.get("prefix") + " Connection Pool: " + this.plugin.getConnectionPool().getStats());
            }
        }
        return true;
    }

    private boolean handleValidate(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "playerdatasync.admin")) {
            return true;
        }
        sender.sendMessage(this.messageManager.get("prefix") + " Data validation completed.");
        return true;
    }

    private boolean handleBackup(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "playerdatasync.admin.backup")) {
            return true;
        }
        String backupType = args.length > 1 ? args[1] : "manual";
        sender.sendMessage(this.messageManager.get("prefix") + " Creating backup...");
        this.plugin.getBackupManager().createBackup(backupType).thenAccept(result -> {
            if (result.isSuccess()) {
                sender.sendMessage(this.messageManager.get("prefix") + " Backup created: " + result.getFileName() + " (" + this.formatFileSize(result.getFileSize()) + ")");
            } else {
                sender.sendMessage(this.messageManager.get("prefix") + " Backup failed!");
            }
        });
        return true;
    }

    private boolean handleRestore(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "playerdatasync.admin.restore")) {
            return true;
        }
        if (args.length < 2) {
            List<BackupManager.BackupInfo> backups = this.plugin.getBackupManager().listBackups();
            if (backups.isEmpty()) {
                sender.sendMessage(this.messageManager.get("prefix") + " No backups available.");
            } else {
                sender.sendMessage(this.messageManager.get("prefix") + " Available backups:");
                for (BackupManager.BackupInfo backup : backups) {
                    sender.sendMessage("\u00a77- \u00a7f" + backup.getFileName() + " \u00a78(" + backup.getFormattedSize() + ", " + String.valueOf(backup.getCreatedDate()) + ")");
                }
            }
            return true;
        }
        String backupName = args[1];
        sender.sendMessage(this.messageManager.get("prefix") + " Restoring from backup: " + backupName);
        this.plugin.getBackupManager().restoreFromBackup(backupName).thenAccept(success -> {
            if (success.booleanValue()) {
                sender.sendMessage(this.messageManager.get("prefix") + " Restore completed successfully!");
            } else {
                sender.sendMessage(this.messageManager.get("prefix") + " Restore failed!");
            }
        });
        return true;
    }

    private boolean handleEditor(CommandSender sender, String[] args) {
        String action;
        if (!this.hasPermission(sender, "playerdatasync.admin.editor")) {
            return true;
        }
        EditorIntegrationManager manager = this.plugin.getEditorIntegrationManager();
        String prefix = this.messageManager.get("prefix") + " ";
        if (manager == null) {
            sender.sendMessage(prefix + this.messageManager.get("editor_disabled"));
            return true;
        }
        switch (action = args.length > 1 ? args[1].toLowerCase() : "token") {
            case "token": {
                Player target;
                if (args.length > 2) {
                    target = Bukkit.getPlayer((String)args[2]);
                    if (target == null) {
                        sender.sendMessage(prefix + this.messageManager.get("player_not_found").replace("{player}", args[2]));
                        return true;
                    }
                } else if (sender instanceof Player) {
                    target = (Player)sender;
                } else {
                    sender.sendMessage(prefix + this.messageManager.get("editor_player_required"));
                    return true;
                }
                String playerName = target.getName();
                sender.sendMessage(prefix + this.messageManager.get("editor_token_generating").replace("{player}", playerName));
                manager.requestEditorToken(target.getUniqueId(), playerName).whenComplete((result, throwable) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (throwable != null) {
                        sender.sendMessage(prefix + this.messageManager.get("editor_token_failed").replace("{error}", throwable.getMessage() != null ? throwable.getMessage() : "unknown error"));
                        return;
                    }
                    if (result == null) {
                        sender.sendMessage(prefix + this.messageManager.get("editor_token_failed").replace("{error}", "no response"));
                        return;
                    }
                    String url = result.getUrl();
                    String token = result.getToken();
                    if (url != null && !url.isEmpty()) {
                        sender.sendMessage(prefix + this.messageManager.get("editor_token_success").replace("{url}", url));
                    }
                    if (token != null && !token.isEmpty()) {
                        String expires = result.getExpiresIn() > 0L ? this.messageManager.get("editor_token_expires").replace("{seconds}", String.valueOf(result.getExpiresIn())) : this.messageManager.get("editor_token_expires_unknown");
                        sender.sendMessage(prefix + this.messageManager.get("editor_token_value").replace("{token}", token).replace("{expires}", expires));
                    } else if (url == null || url.isEmpty()) {
                        sender.sendMessage(prefix + this.messageManager.get("editor_token_failed").replace("{error}", "missing token"));
                    }
                }));
                return true;
            }
            case "snapshot": {
                sender.sendMessage(prefix + this.messageManager.get("editor_snapshot_start"));
                manager.pushSnapshot().whenComplete((success, throwable) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (throwable != null) {
                        sender.sendMessage(prefix + this.messageManager.get("editor_snapshot_failed").replace("{error}", throwable.getMessage() != null ? throwable.getMessage() : "unknown error"));
                    } else {
                        sender.sendMessage(prefix + this.messageManager.get("editor_snapshot_success"));
                    }
                }));
                return true;
            }
            case "heartbeat": {
                boolean online;
                if (args.length < 3) {
                    sender.sendMessage(prefix + this.messageManager.get("editor_heartbeat_usage"));
                    return true;
                }
                if (args[2].equalsIgnoreCase("online")) {
                    online = true;
                } else if (args[2].equalsIgnoreCase("offline")) {
                    online = false;
                } else {
                    sender.sendMessage(prefix + this.messageManager.get("editor_heartbeat_usage"));
                    return true;
                }
                manager.sendHeartbeatAsync(online).whenComplete((success, throwable) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (throwable != null) {
                        sender.sendMessage(prefix + this.messageManager.get("editor_heartbeat_failed").replace("{error}", throwable.getMessage() != null ? throwable.getMessage() : "unknown error"));
                    } else {
                        sender.sendMessage(prefix + this.messageManager.get("editor_heartbeat_success").replace("{status}", online ? this.messageManager.get("editor_status_online") : this.messageManager.get("editor_status_offline")));
                    }
                }));
                return true;
            }
        }
        sender.sendMessage(prefix + this.messageManager.get("editor_usage"));
        return true;
    }

    private boolean handleAchievements(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "playerdatasync.admin.achievements")) {
            return true;
        }
        AdvancementSyncManager advancementSyncManager = this.plugin.getAdvancementSyncManager();
        if (advancementSyncManager == null) {
            sender.sendMessage(this.messageManager.get("prefix") + " Advancement manager is not available.");
            return true;
        }
        String prefix = this.messageManager.get("prefix") + " ";
        if (args.length == 1 || args[1].equalsIgnoreCase("status")) {
            sender.sendMessage(prefix + "Advancement cache: " + advancementSyncManager.getGlobalImportStatus());
            if (args.length > 2) {
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    sender.sendMessage(prefix + "Player '" + args[2] + "' is not online.");
                } else {
                    sender.sendMessage(prefix + target.getName() + ": " + advancementSyncManager.getPlayerStatus(target.getUniqueId()));
                }
            } else if (sender instanceof Player) {
                Player player = (Player)sender;
                sender.sendMessage(prefix + "You: " + advancementSyncManager.getPlayerStatus(player.getUniqueId()));
            }
            sender.sendMessage(prefix + "Use /sync achievements import [player] to queue an import.");
            return true;
        }
        String action = args[1].toLowerCase();
        if (action.equals("import") || action.equals("preload")) {
            if (args.length == 2) {
                boolean started = advancementSyncManager.startGlobalImport(true);
                if (started) {
                    sender.sendMessage(prefix + "Started global advancement cache rebuild.");
                } else if (advancementSyncManager.getGlobalImportStatus().startsWith("running")) {
                    sender.sendMessage(prefix + "Global advancement cache rebuild is already running.");
                } else {
                    sender.sendMessage(prefix + "Advancement cache already up to date. Use /sync achievements import again later to rebuild.");
                }
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                sender.sendMessage(prefix + "Player '" + args[2] + "' is not online.");
                return true;
            }
            advancementSyncManager.forceRescan(target);
            sender.sendMessage(prefix + "Queued advancement import for " + target.getName() + ".");
            return true;
        }
        sender.sendMessage(prefix + "Unknown achievements subcommand. Try /sync achievements status or /sync achievements import");
        return true;
    }

    private String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    private boolean handleSyncOption(CommandSender sender, String option, String value) {
        if (!this.hasPermission(sender, "playerdatasync.admin." + option)) {
            return true;
        }
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("invalid_syntax").replace("{usage}", "/sync <option> <true|false>"));
            return true;
        }
        boolean enabled = Boolean.parseBoolean(value);
        if (this.setSyncOptionValue(option, enabled)) {
            String message = enabled ? this.messageManager.get("sync_enabled") : this.messageManager.get("sync_disabled");
            sender.sendMessage(this.messageManager.get("prefix") + " " + message.replace("{option}", option));
        } else {
            sender.sendMessage(this.messageManager.get("prefix") + " Unknown option: " + option);
        }
        return true;
    }

    private boolean showHelp(CommandSender sender) {
        sender.sendMessage(this.messageManager.get("help_header"));
        sender.sendMessage(this.messageManager.get("help_sync"));
        sender.sendMessage(this.messageManager.get("help_sync_option"));
        sender.sendMessage(this.messageManager.get("help_sync_reload"));
        sender.sendMessage(this.messageManager.get("help_sync_save"));
        sender.sendMessage("\u00a7b/sync status [player] \u00a78- \u00a77Check sync status");
        sender.sendMessage("\u00a7b/sync cache [clear] \u00a78- \u00a77Manage cache and performance stats");
        sender.sendMessage("\u00a7b/sync validate \u00a78- \u00a77Validate data integrity");
        sender.sendMessage("\u00a7b/sync backup [type] \u00a78- \u00a77Create manual backup");
        sender.sendMessage("\u00a7b/sync restore [backup] \u00a78- \u00a77Restore from backup");
        sender.sendMessage("\u00a7b/sync editor token [player] \u00a78- \u00a77Generate web editor access");
        sender.sendMessage("\u00a7b/sync help \u00a78- \u00a77Show this help");
        sender.sendMessage(this.messageManager.get("help_footer"));
        return true;
    }

    private void showPlayerStatus(CommandSender sender, Player player) {
        sender.sendMessage("\u00a78\u00a7m----------\u00a7r \u00a7bPlayer Status: " + player.getName() + " \u00a78\u00a7m----------");
        sender.sendMessage("\u00a77Online: \u00a7aYes");
        sender.sendMessage("\u00a77World: \u00a7f" + player.getWorld().getName());
        sender.sendMessage("\u00a77Location: \u00a7f" + String.format("%.1f, %.1f, %.1f", player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ()));
        double maxHealth = 20.0;
        try {
            if (VersionCompatibility.isAttributesSupported()) {
                AttributeInstance attr = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (attr != null) {
                    maxHealth = attr.getValue();
                }
            } else {
                double tempMax;
                maxHealth = tempMax = player.getMaxHealth();
            }
        }
        catch (Exception e) {
            maxHealth = 20.0;
        }
        sender.sendMessage("\u00a77Health: \u00a7f" + String.format("%.1f/%.1f", player.getHealth(), maxHealth));
        sender.sendMessage("\u00a77Food Level: \u00a7f" + player.getFoodLevel() + "/20");
        sender.sendMessage("\u00a77XP Level: \u00a7f" + player.getLevel());
        sender.sendMessage("\u00a77Game Mode: \u00a7f" + player.getGameMode().toString());
        sender.sendMessage("\u00a78\u00a7m----------------------------------------");
    }

    private boolean getSyncOptionValue(String option) {
        switch (option.toLowerCase()) {
            case "coordinates": {
                return this.plugin.isSyncCoordinates();
            }
            case "position": {
                return this.plugin.isSyncPosition();
            }
            case "xp": {
                return this.plugin.isSyncXp();
            }
            case "gamemode": {
                return this.plugin.isSyncGamemode();
            }
            case "inventory": {
                return this.plugin.isSyncInventory();
            }
            case "enderchest": {
                return this.plugin.isSyncEnderchest();
            }
            case "armor": {
                return this.plugin.isSyncArmor();
            }
            case "offhand": {
                return this.plugin.isSyncOffhand();
            }
            case "health": {
                return this.plugin.isSyncHealth();
            }
            case "hunger": {
                return this.plugin.isSyncHunger();
            }
            case "effects": {
                return this.plugin.isSyncEffects();
            }
            case "achievements": {
                return this.plugin.isSyncAchievements();
            }
            case "statistics": {
                return this.plugin.isSyncStatistics();
            }
            case "attributes": {
                return this.plugin.isSyncAttributes();
            }
            case "permissions": {
                return this.plugin.isSyncPermissions();
            }
            case "economy": {
                return this.plugin.isSyncEconomy();
            }
        }
        return false;
    }

    private boolean setSyncOptionValue(String option, boolean value) {
        switch (option.toLowerCase()) {
            case "coordinates": {
                this.plugin.setSyncCoordinates(value);
                return true;
            }
            case "position": {
                this.plugin.setSyncPosition(value);
                return true;
            }
            case "xp": {
                this.plugin.setSyncXp(value);
                return true;
            }
            case "gamemode": {
                this.plugin.setSyncGamemode(value);
                return true;
            }
            case "inventory": {
                this.plugin.setSyncInventory(value);
                return true;
            }
            case "enderchest": {
                this.plugin.setSyncEnderchest(value);
                return true;
            }
            case "armor": {
                this.plugin.setSyncArmor(value);
                return true;
            }
            case "offhand": {
                this.plugin.setSyncOffhand(value);
                return true;
            }
            case "health": {
                this.plugin.setSyncHealth(value);
                return true;
            }
            case "hunger": {
                this.plugin.setSyncHunger(value);
                return true;
            }
            case "effects": {
                this.plugin.setSyncEffects(value);
                return true;
            }
            case "achievements": {
                this.plugin.setSyncAchievements(value);
                return true;
            }
            case "statistics": {
                this.plugin.setSyncStatistics(value);
                return true;
            }
            case "attributes": {
                this.plugin.setSyncAttributes(value);
                return true;
            }
            case "permissions": {
                this.plugin.setSyncPermissions(value);
                return true;
            }
            case "economy": {
                this.plugin.setSyncEconomy(value);
                return true;
            }
        }
        return false;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(permission) || sender.hasPermission("playerdatasync.admin.*")) {
            return true;
        }
        sender.sendMessage(this.messageManager.get("prefix") + " " + this.messageManager.get("no_permission"));
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(SUB_COMMANDS);
            completions.addAll(SYNC_OPTIONS);
            return completions.stream().filter(s2 -> s2.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String firstArg = args[0].toLowerCase();
            if (SYNC_OPTIONS.contains(firstArg)) {
                return Arrays.asList("true", "false").stream().filter(s2 -> s2.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (firstArg.equals("status") || firstArg.equals("save")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (firstArg.equals("cache")) {
                return Arrays.asList("clear", "stats").stream().filter(s2 -> s2.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (firstArg.equals("backup")) {
                return Arrays.asList("manual", "automatic", "scheduled").stream().filter(s2 -> s2.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (firstArg.equals("achievements")) {
                return Arrays.asList("status", "import").stream().filter(s2 -> s2.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (firstArg.equals("editor")) {
                return Arrays.asList("token", "snapshot", "heartbeat").stream().filter(s2 -> s2.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (firstArg.equals("restore")) {
                return this.plugin.getBackupManager().listBackups().stream().map(BackupManager.BackupInfo::getFileName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        if (args.length == 3) {
            String second;
            if (args[0].equalsIgnoreCase("achievements") && ((second = args[1].toLowerCase()).equals("status") || second.equals("import") || second.equals("preload"))) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("editor")) {
                second = args[1].toLowerCase();
                if (second.equals("token")) {
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
                }
                if (second.equals("heartbeat")) {
                    return Arrays.asList("online", "offline").stream().filter(s2 -> s2.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
                }
            }
        }
        return completions;
    }
}

