/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerdatasync.api;

import com.example.playerdatasync.libs.gson.JsonObject;
import com.example.playerdatasync.libs.gson.JsonParser;
import com.example.playerdatasync.managers.MessageManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private static final String API_BASE_URL = "https://craftingstudiopro.de/api";
    private static final String PLUGIN_SLUG = "playerdatasync";
    private final JavaPlugin plugin;
    private final MessageManager messageManager;

    public UpdateChecker(JavaPlugin plugin, MessageManager messageManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
    }

    public void check() {
        if (!this.plugin.getConfig().getBoolean("update_checker.enabled", true)) {
            this.plugin.getLogger().info(this.messageManager.get("update_check_disabled"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpURLConnection connection;
                String apiUrl = "https://craftingstudiopro.de/api/plugins/playerdatasync/latest";
                try {
                    URI uri = new URI(apiUrl);
                    connection = (HttpURLConnection)uri.toURL().openConnection();
                }
                catch (URISyntaxException e) {
                    URL fallbackUrl = new URL(apiUrl);
                    connection = (HttpURLConnection)fallbackUrl.openConnection();
                }
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "PlayerDataSync/" + this.plugin.getDescription().getVersion());
                connection.setRequestProperty("Accept", "application/json");
                int responseCode = connection.getResponseCode();
                if (responseCode == 429) {
                    this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", "Rate limit exceeded. Please try again later."));
                    return;
                }
                if (responseCode != 200) {
                    this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", "HTTP " + responseCode));
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String currentVersion;
                    JsonObject jsonObject;
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    String jsonResponse = response.toString();
                    if (jsonResponse == null || jsonResponse.trim().isEmpty()) {
                        this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", "Empty response"));
                        return;
                    }
                    try {
                        jsonObject = JsonParser.parseString(jsonResponse).getAsJsonObject();
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", "Invalid JSON response: " + e.getMessage()));
                        reader.close();
                        return;
                    }
                    if (!jsonObject.has("version")) {
                        this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", "Invalid response format: missing version field"));
                        return;
                    }
                    String latestVersion = jsonObject.get("version").getAsString();
                    String downloadUrl = null;
                    if (jsonObject.has("downloadUrl") && !jsonObject.get("downloadUrl").isJsonNull()) {
                        downloadUrl = jsonObject.get("downloadUrl").getAsString();
                    }
                    if ((currentVersion = this.plugin.getDescription().getVersion()).equalsIgnoreCase(latestVersion)) {
                        if (this.plugin.getConfig().getBoolean("update_checker.notify_ops", true)) {
                            this.plugin.getLogger().info(this.messageManager.get("update_current"));
                        }
                    } else {
                        this.plugin.getLogger().info(this.messageManager.get("update_available", latestVersion));
                        if (downloadUrl != null && !downloadUrl.isEmpty()) {
                            this.plugin.getLogger().info(this.messageManager.get("update_download_url", downloadUrl));
                        } else {
                            this.plugin.getLogger().info(this.messageManager.get("update_download_url", "https://craftingstudiopro.de/plugins/playerdatasync"));
                        }
                    }
                }
            }
            catch (UnknownHostException e) {
                this.plugin.getLogger().fine(this.messageManager.get("update_check_no_internet"));
            }
            catch (SocketTimeoutException e) {
                this.plugin.getLogger().warning(this.messageManager.get("update_check_timeout"));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning(this.messageManager.get("update_check_failed", e.getMessage()));
                this.plugin.getLogger().log(Level.FINE, "Update check error", e);
            }
        });
    }
}

